/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.quorum.pool.complex.DeconstructionCoordinator;
import org.smallmind.quorum.pool.complex.DeconstructionFuse;
import org.smallmind.quorum.pool.complex.DeconstructionQueue;
import org.smallmind.scribe.pen.LoggerManager;

public class MaxProcessingTimeDeconstructionFuse
extends DeconstructionFuse {
    private final ComponentPool<?> componentPool;
    private final AtomicInteger generation = new AtomicInteger(0);
    private final AtomicInteger generationServed = new AtomicInteger(0);

    protected MaxProcessingTimeDeconstructionFuse(ComponentPool<?> componentPool, DeconstructionQueue deconstructionQueue, DeconstructionCoordinator deconstructionCoordinator) {
        super(deconstructionQueue, deconstructionCoordinator);
        this.componentPool = componentPool;
    }

    @Override
    public boolean isPrejudicial() {
        return true;
    }

    @Override
    public synchronized void free() {
        this.generation.incrementAndGet();
        this.abort();
    }

    @Override
    public void serve() {
        this.generationServed.set(this.generation.incrementAndGet());
        this.setIgnitionTime(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.componentPool.getComplexPoolConfig().getMaxProcessingTimeSeconds()));
    }

    @Override
    public synchronized void ignite() {
        if (this.generationServed.get() == this.generation.get()) {
            StackTraceElement[] stackTraceElements = this.getExistentialStackTrace();
            super.ignite();
            if (stackTraceElements != null && stackTraceElements.length > 0) {
                LoggerManager.getLogger(MaxProcessingTimeDeconstructionFuse.class).warn((Object)Arrays.toString(this.getExistentialStackTrace()));
            }
        }
    }
}

