/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.namespace.backingStore;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.smallmind.quorum.namespace.ContextNamePair;
import org.smallmind.quorum.namespace.JavaName;
import org.smallmind.quorum.namespace.backingStore.ContextCreator;

public abstract class NameTranslator {
    private final ContextCreator contextCreator;

    public NameTranslator(ContextCreator contextCreator) {
        this.contextCreator = contextCreator;
    }

    public ContextCreator getContextCreator() {
        return this.contextCreator;
    }

    public ContextNamePair fromInternalNameToExternalContext(DirContext internalContext, Name internalName) throws NamingException {
        if (internalContext == null) {
            if (internalName.size() == 0 || !internalName.get(0).equals("java:")) {
                throw new NamingException("No starting context from which to resolve (" + String.valueOf(internalName) + ")");
            }
            try {
                return new ContextNamePair(this.contextCreator.getInitialContext(), this.fromInternalNameToExternalName(internalName.getSuffix(1)));
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception e) {
                NamingException namingException = new NamingException(e.getMessage());
                namingException.setRootCause(e);
                throw namingException;
            }
        }
        return new ContextNamePair(internalContext, this.fromInternalNameToExternalName(internalName));
    }

    public abstract JavaName fromInternalNameToExternalName(Name var1) throws InvalidNameException;

    public abstract String fromExternalNameToExternalString(JavaName var1);

    public abstract String fromAbsoluteExternalStringToInternalString(String var1) throws InvalidNameException;

    public abstract String fromExternalStringToInternalString(String var1) throws InvalidNameException;
}

