/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.quorum.pool.complex.ComponentPin;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.quorum.pool.complex.DeconstructionFuse;
import org.smallmind.quorum.pool.complex.DeconstructionQueue;
import org.smallmind.quorum.pool.complex.MaxIdleTimeDeconstructionFuse;
import org.smallmind.quorum.pool.complex.MaxLeaseTimeDeconstructionFuse;
import org.smallmind.quorum.pool.complex.MaxProcessingTimeDeconstructionFuse;
import org.smallmind.scribe.pen.LoggerManager;

public class DeconstructionCoordinator {
    private final ComponentPin<?> componentPin;
    private final List<DeconstructionFuse> fuseList;
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    public DeconstructionCoordinator(ComponentPool<?> componentPool, DeconstructionQueue deconstructionQueue, ComponentPin<?> componentPin) {
        this.componentPin = componentPin;
        this.fuseList = new LinkedList<DeconstructionFuse>();
        if (componentPool.getComplexPoolConfig().getMaxLeaseTimeSeconds() > 0) {
            this.fuseList.add(new MaxLeaseTimeDeconstructionFuse(componentPool, deconstructionQueue, this));
        }
        if (componentPool.getComplexPoolConfig().getMaxIdleTimeSeconds() > 0) {
            this.fuseList.add(new MaxIdleTimeDeconstructionFuse(componentPool, deconstructionQueue, this));
        }
        if (componentPool.getComplexPoolConfig().getMaxProcessingTimeSeconds() > 0) {
            this.fuseList.add(new MaxProcessingTimeDeconstructionFuse(componentPool, deconstructionQueue, this));
        }
    }

    public StackTraceElement[] getExistentialStackTrace() {
        return this.componentPin.getExistentialStackTrace();
    }

    public void free() {
        for (DeconstructionFuse fuse : this.fuseList) {
            fuse.free();
        }
    }

    public void serve() {
        for (DeconstructionFuse fuse : this.fuseList) {
            fuse.serve();
        }
    }

    public void abort() {
        if (this.terminated.compareAndSet(false, true)) {
            this.shutdown(null);
        }
    }

    public void ignite(DeconstructionFuse ignitionFuse, boolean withPrejudice) {
        if (this.terminated.compareAndSet(false, true)) {
            LoggerManager.getLogger(DeconstructionCoordinator.class).debug("ComponentPin being terminated due to fuse(%s) ignition", new Object[]{ignitionFuse.getClass().getSimpleName()});
            this.shutdown(ignitionFuse);
            this.componentPin.kaboom(withPrejudice);
        }
    }

    private void shutdown(DeconstructionFuse ignitionFuse) {
        for (DeconstructionFuse fuse : this.fuseList) {
            if (fuse.equals(ignitionFuse)) continue;
            fuse.abort();
        }
    }
}

