/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.seda;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.seda.DurationMonitor;
import org.smallmind.seda.Event;
import org.smallmind.seda.EventQueue;
import org.smallmind.seda.SedaConfiguration;
import org.smallmind.seda.StopWatch;
import org.smallmind.seda.WorkMonitor;

public class EventProcessor<I extends Event, O extends Event>
implements Runnable {
    private CountDownLatch exitLatch;
    private SedaConfiguration sedaConfiguration;
    private EventQueue<I> eventQueue;
    private WorkMonitor monitor;
    private AtomicBoolean stopped = new AtomicBoolean(false);

    public EventProcessor(EventQueue<I> eventQueue, DurationMonitor durationMonitor, SedaConfiguration sedaConfiguration) {
        this.eventQueue = eventQueue;
        this.monitor = new WorkMonitor(durationMonitor, sedaConfiguration.getWorkTrackingTime(), sedaConfiguration.getWorkTrackingTimeUnit());
        this.exitLatch = new CountDownLatch(1);
    }

    protected WorkMonitor getMonitor() {
        return this.monitor;
    }

    public double getIdlePercentage() {
        return this.monitor.getIdlePercentage();
    }

    public double getActivePercentage() {
        return this.monitor.getActivePercentage();
    }

    public boolean isRunning() {
        return !this.stopped.get();
    }

    protected void stop() throws InterruptedException {
        this.stopped.compareAndSet(false, true);
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StopWatch stopWatch = new StopWatch();
        try {
            stopWatch.click();
            while (!this.stopped.get()) {
                I inputEvent = this.eventQueue.poll(this.sedaConfiguration.getQueuePollTimeout(), this.sedaConfiguration.getQueuePollTimeUnit());
                if (inputEvent != null) {
                    this.monitor.addIdleTime(stopWatch.click());
                    this.monitor.addActiveTime(stopWatch.click());
                    continue;
                }
                this.monitor.addIdleTime(stopWatch.click());
            }
        }
        catch (InterruptedException interruptedException) {
            this.stopped.compareAndSet(false, true);
            LoggerManager.getLogger(EventProcessor.class).error((Throwable)interruptedException);
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

