/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.seda;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.seda.DurationMonitor;
import org.smallmind.seda.Event;
import org.smallmind.seda.EventProcessor;
import org.smallmind.seda.SedaConfiguration;
import org.smallmind.seda.ThreadPool;

public class HomeostaticRegulator<I extends Event, O extends Event>
implements Runnable {
    private final LinkedList<EventProcessor<I, O>> processorList;
    private CountDownLatch exitLatch;
    private CountDownLatch pulseLatch;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private SedaConfiguration sedaConfiguration;
    private ThreadPool<I, O> threadPool;

    public HomeostaticRegulator(ThreadPool<I, O> threadPool, DurationMonitor durationMonitor, LinkedList<EventProcessor<I, O>> processorList, SedaConfiguration sedaConfiguration) {
        this.threadPool = threadPool;
        this.processorList = processorList;
        this.sedaConfiguration = sedaConfiguration;
        this.exitLatch = new CountDownLatch(1);
        this.pulseLatch = new CountDownLatch(1);
    }

    public boolean isRunning() {
        return !this.stopped.get();
    }

    protected void stop() throws InterruptedException {
        if (this.stopped.compareAndSet(false, true)) {
            this.pulseLatch.countDown();
        }
        this.exitLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stopped.get()) {
                try {
                    this.pulseLatch.await(this.sedaConfiguration.getRegulatorPulseTime(), this.sedaConfiguration.getRegulatorPulseTimeUnit());
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(HomeostaticRegulator.class).error((Throwable)interruptedException);
                }
                if (this.stopped.get()) continue;
                double idlePercentage = 0.0;
                double activePercentage = 0.0;
                LinkedList<EventProcessor<I, O>> linkedList = this.processorList;
                synchronized (linkedList) {
                    for (EventProcessor eventProcessor : this.processorList) {
                        idlePercentage += eventProcessor.getIdlePercentage();
                        activePercentage += eventProcessor.getActivePercentage();
                    }
                    idlePercentage /= (double)this.processorList.size();
                    activePercentage /= (double)this.processorList.size();
                }
                if (this.sedaConfiguration.getActiveUpShiftPercentage() >= activePercentage) {
                    this.threadPool.increase();
                    continue;
                }
                if (!(this.sedaConfiguration.getInactiveDownShiftPercentage() >= idlePercentage)) continue;
                this.threadPool.decrease();
            }
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

