/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.seda;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.seda.DurationMonitor;
import org.smallmind.seda.StopWatch;

public class WorkMonitor {
    private static final double BY_MILLIS = 1000000.0;
    private ReentrantReadWriteLock lock;
    private TimeNormalizer idleNormalizer;
    private TimeNormalizer activeNormalizer;
    private DurationMonitor durationMonitor;

    public WorkMonitor(DurationMonitor durationMonitor, long trackingTime, TimeUnit trackingTimeUnit) {
        this.durationMonitor = durationMonitor;
        this.idleNormalizer = new TimeNormalizer(trackingTimeUnit.toMillis(trackingTime));
        this.activeNormalizer = new TimeNormalizer(trackingTimeUnit.toMillis(trackingTime));
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getIdlePercentage() {
        this.lock.readLock().lock();
        try {
            double idleTime = this.idleNormalizer.getTotal();
            double totalTime = idleTime + this.activeNormalizer.getTotal();
            if (totalTime == 0.0) {
                double d = 0.0;
                return d;
            }
            double d = idleTime / totalTime * 100.0;
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getActivePercentage() {
        this.lock.readLock().lock();
        try {
            double activeTime = this.activeNormalizer.getTotal();
            double totalTime = this.idleNormalizer.getTotal() + activeTime;
            if (totalTime == 0.0) {
                double d = 0.0;
                return d;
            }
            double d = activeTime / totalTime * 100.0;
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIdleTime(StopWatch stopWatch) {
        double end = (double)stopWatch.getStartMillis() + (double)stopWatch.getDurationNanos() / 1000000.0;
        this.lock.writeLock().lock();
        try {
            this.idleNormalizer.additional(stopWatch.getStartMillis(), end);
            this.activeNormalizer.update(end);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addActiveTime(StopWatch stopWatch) {
        double end = (double)stopWatch.getStartMillis() + (double)stopWatch.getDurationNanos() / 1000000.0;
        this.lock.writeLock().lock();
        try {
            this.activeNormalizer.additional(stopWatch.getStartMillis(), end);
            this.idleNormalizer.update(end);
            this.durationMonitor.accumulate(stopWatch.getDurationNanos());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static class TimeNormalizer {
        private boolean initialized = false;
        private double start;
        private double stop;
        private double average;
        private long track;

        public TimeNormalizer(long track) {
            this.track = track;
        }

        public double getTotal() {
            if (!this.initialized) {
                return 0.0;
            }
            return (this.stop - this.start) * this.average;
        }

        public void update(double end) {
            if (this.initialized) {
                double d;
                double oldest = end - (double)this.track;
                if (d > this.stop) {
                    this.start = 0.0;
                    this.stop = 0.0;
                    this.average = 0.0;
                } else {
                    oldest = Math.max(this.start, oldest);
                    this.average = (this.stop - oldest) * this.average / (end - oldest);
                    this.start = oldest;
                    this.stop = end;
                }
            }
        }

        public void additional(long begin, double end) {
            if (end > (double)begin) {
                if (!this.initialized) {
                    this.initialized = true;
                    this.start = begin;
                    this.stop = end;
                    this.average = 1.0;
                } else {
                    double d;
                    double oldest = end - (double)this.track;
                    if (d > this.stop) {
                        this.start = begin;
                        this.average = 1.0;
                    } else {
                        oldest = Math.max(this.start, oldest);
                        this.average = ((this.stop - oldest) * this.average + (end - (double)begin)) / (end - oldest);
                        this.start = oldest;
                    }
                    this.stop = end;
                }
            }
        }
    }
}

