/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.seda;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.scribe.pen.LoggerManager;
import org.smallmind.seda.DurationMonitor;
import org.smallmind.seda.Event;
import org.smallmind.seda.EventProcessor;
import org.smallmind.seda.EventQueue;
import org.smallmind.seda.HomeostaticRegulator;
import org.smallmind.seda.SedaConfiguration;

public class ThreadPool<I extends Event, O extends Event> {
    private final LinkedList<EventProcessor<I, O>> processorList;
    private CountDownLatch exitLatch;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private SedaConfiguration sedaConfiguration;
    private EventQueue<I> eventQueue;
    private DurationMonitor durationMonitor;
    private HomeostaticRegulator<I, O> homeostaticRegulator;

    public ThreadPool(EventQueue<I> eventQueue, SedaConfiguration sedaConfiguration) {
        this.sedaConfiguration = sedaConfiguration;
        this.eventQueue = eventQueue;
        this.durationMonitor = new DurationMonitor(sedaConfiguration.getMaxTrackedInvocations());
        this.processorList = new LinkedList();
        this.homeostaticRegulator = new HomeostaticRegulator<I, O>(this, this.durationMonitor, this.processorList, sedaConfiguration);
        Thread regulatorThread = new Thread(this.homeostaticRegulator);
        regulatorThread.start();
        this.exitLatch = new CountDownLatch(1);
    }

    public boolean isRunning() {
        return !this.stopped.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void increase() {
        LinkedList<EventProcessor<I, O>> linkedList = this.processorList;
        synchronized (linkedList) {
            if (!(this.stopped.get() || this.sedaConfiguration.getMaxThreadPoolSize() != 0 && this.processorList.size() >= this.sedaConfiguration.getMaxThreadPoolSize())) {
                EventProcessor eventProcessor = new EventProcessor(this.eventQueue, this.durationMonitor, this.sedaConfiguration);
                Thread processorThread = new Thread(eventProcessor);
                processorThread.start();
                this.processorList.add(eventProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrease() {
        LinkedList<EventProcessor<I, O>> linkedList = this.processorList;
        synchronized (linkedList) {
            if (!this.stopped.get() && !this.processorList.isEmpty() && this.processorList.size() > this.sedaConfiguration.getMinThreadPoolSize()) {
                try {
                    this.processorList.removeFirst().stop();
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(ThreadPool.class).error((Throwable)interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws InterruptedException {
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.homeostaticRegulator.stop();
            }
            catch (InterruptedException interruptedException) {
                LoggerManager.getLogger(ThreadPool.class).error((Throwable)interruptedException);
            }
            LinkedList<EventProcessor<I, O>> linkedList = this.processorList;
            synchronized (linkedList) {
                while (!this.processorList.isEmpty()) {
                    try {
                        this.processorList.removeFirst().stop();
                    }
                    catch (InterruptedException interruptedException) {
                        LoggerManager.getLogger(ThreadPool.class).error((Throwable)interruptedException);
                    }
                }
            }
            this.exitLatch.countDown();
        } else {
            this.exitLatch.await();
        }
    }
}

