/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.behavior.freemarker;

import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.smallmind.wicket.util.FreeMarkerPackageTextTemplate;

public class FreeMarkerJavaScriptBehavior
extends Behavior {
    private Map<String, Object> rootModel;
    private Class<?> scopeClass;
    private String fileName;

    public FreeMarkerJavaScriptBehavior(Map<String, Object> rootModel) {
        this(null, null, rootModel);
    }

    public FreeMarkerJavaScriptBehavior(String fileName, Map<String, Object> rootModel) {
        this(null, fileName, rootModel);
    }

    public FreeMarkerJavaScriptBehavior(Class<?> scopeClass, String fileName, Map<String, Object> rootModel) {
        this.scopeClass = scopeClass;
        this.fileName = fileName;
        this.rootModel = rootModel;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        Class<?> interpolatedClass = this.scopeClass != null ? this.scopeClass : component.getClass();
        String interpolatedFileName = this.fileName == null ? component.getClass().getSimpleName() + ".js" : this.fileName;
        response.renderJavaScript((CharSequence)new FreeMarkerPackageTextTemplate(interpolatedClass, interpolatedFileName).asString(this.rootModel), interpolatedClass.getName() + ":" + interpolatedFileName);
    }
}

