/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import java.util.Date;
import org.joda.time.DateTime;
import org.smallmind.wicket.component.google.visualization.TimeBasedValue;
import org.smallmind.wicket.component.google.visualization.ValueType;

public class DateTimeValue
extends TimeBasedValue {
    private static DateTimeValue NULL_VALUE = new DateTimeValue(null);

    public static DateTimeValue asNull() {
        return NULL_VALUE;
    }

    public static DateTimeValue create(long milliseconds) {
        return new DateTimeValue(new DateTime(milliseconds));
    }

    public static DateTimeValue create(Long milliseconds) {
        return milliseconds == null ? NULL_VALUE : new DateTimeValue(new DateTime((Object)milliseconds));
    }

    public static DateTimeValue create(Date date) {
        return date == null ? NULL_VALUE : new DateTimeValue(new DateTime((Object)date));
    }

    private DateTimeValue(DateTime instant) {
        super(instant);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATETIME;
    }

    public int getYear() {
        return this.getInstant().getYear();
    }

    public int getMonth() {
        return this.getInstant().getMonthOfYear() - 1;
    }

    public int getDay() {
        return this.getInstant().getDayOfMonth();
    }

    public int getHour() {
        return this.getInstant().getHourOfDay();
    }

    public int getMinute() {
        return this.getInstant().getMinuteOfHour();
    }

    public int getSecond() {
        return this.getInstant().getSecondOfMinute();
    }

    public int getMillisecond() {
        return this.getInstant().getMillisOfSecond();
    }

    @Override
    public String forScript() {
        if (this.getInstant() == null) {
            return "null";
        }
        StringBuilder dateTimeBuilder = new StringBuilder("new Date(");
        dateTimeBuilder.append(this.getYear()).append(',').append(this.getMonth()).append(',').append(this.getDay()).append(',').append(this.getHour()).append(',').append(this.getMinute()).append(',').append(this.getSecond()).append(',').append(this.getMillisecond()).append(')');
        return dateTimeBuilder.toString();
    }
}

