/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import org.smallmind.nutsnbolts.lang.TypeMismatchException;
import org.smallmind.wicket.component.google.visualization.Value;
import org.smallmind.wicket.component.google.visualization.ValueType;

public class NumberValue
extends Value {
    private static NumberValue NULL_VALUE = new NumberValue(null);
    private Double number;

    public static NumberValue asNull() {
        return NULL_VALUE;
    }

    public static NumberValue create(double number) {
        return new NumberValue(number);
    }

    public static NumberValue create(Double number) {
        return number == null ? NULL_VALUE : new NumberValue(number);
    }

    private NumberValue(Double number) {
        this.number = number;
    }

    public synchronized Double getNumber() {
        return this.number;
    }

    public synchronized void add(double number) {
        if (this.number == null) {
            throw new UnsupportedOperationException("Can't manipulate a null value");
        }
        NumberValue numberValue = this;
        numberValue.number = numberValue.number + number;
    }

    @Override
    public ValueType getType() {
        return ValueType.NUMBER;
    }

    @Override
    public boolean isNull() {
        return this.number == null;
    }

    @Override
    public int compareTo(Value value) {
        if (!ValueType.NUMBER.equals((Object)value.getType())) {
            throw new TypeMismatchException();
        }
        if (this.isNull()) {
            return value.isNull() ? 0 : -1;
        }
        if (value.isNull()) {
            return 1;
        }
        return this.number.compareTo(((NumberValue)value).getNumber());
    }

    @Override
    public String forScript() {
        return this.toString();
    }

    public String toString() {
        return this.number == null ? "null" : this.number.toString();
    }
}

