/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.radio;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.smallmind.wicket.component.radio.AjaxRadio;

public abstract class EnumRadioPanel<E extends Enum>
extends Panel {
    private E selection;

    public EnumRadioPanel(String id, Class<E> enumClass) {
        this(id, enumClass, null);
    }

    public EnumRadioPanel(String id, Class<E> enumClass, E selection) {
        super(id);
        final Enum[] enumerations = (Enum[])enumClass.getEnumConstants();
        this.selection = selection;
        Component[] componentArray = new Component[1];
        RadioGroup radioGroup = new RadioGroup("enumRadioGroup", (IModel)new Model(selection));
        componentArray[0] = radioGroup;
        this.add(componentArray);
        radioGroup.add(new Component[]{new Loop("enumRadioLoop", (IModel)new Model((Serializable)Integer.valueOf(enumerations.length))){

            protected void populateItem(LoopItem item) {
                item.add(new Component[]{new Label("enumRadioLabel", (IModel)new Model((Serializable)((Object)enumerations[item.getIndex()].toString())))});
                item.add(new Component[]{new AjaxRadio<E>("enumRadioButton", (IModel)new Model((Serializable)((Object)enumerations[item.getIndex()]))){

                    @Override
                    public void onClick(E selection, AjaxRequestTarget target) {
                        EnumRadioPanel.this.selection = selection;
                        EnumRadioPanel.this.onClick(selection, target);
                    }
                }});
            }
        }});
    }

    public E getSelection() {
        return this.selection;
    }

    public abstract void onClick(E var1, AjaxRequestTarget var2);
}

