/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.behavior;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.util.template.PackageTextTemplate;

public class CssBehavior
extends Behavior {
    private Map<String, Object> substitutionMap;
    private Class scopeClass;
    private String fileName;

    public CssBehavior() {
        this(null, null, null);
    }

    public CssBehavior(Properties cssProperties) {
        this(null, null, cssProperties);
    }

    public CssBehavior(String fileName) {
        this(null, fileName, null);
    }

    public CssBehavior(String fileName, Properties cssProperties) {
        this(null, fileName, cssProperties);
    }

    public CssBehavior(Class scopeClass) {
        this(scopeClass, null, null);
    }

    public CssBehavior(Class scopeClass, Properties cssProperties) {
        this(scopeClass, null, cssProperties);
    }

    public CssBehavior(Class scopeClass, String fileName, Properties cssProperties) {
        this.scopeClass = scopeClass;
        this.fileName = fileName;
        if (cssProperties != null) {
            this.substitutionMap = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> propertyEntry : cssProperties.entrySet()) {
                this.substitutionMap.put(propertyEntry.getKey().toString(), propertyEntry.getValue());
            }
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        Class<?> interpolatedClass;
        Class<?> clazz = interpolatedClass = this.scopeClass != null ? this.scopeClass : component.getClass();
        String interpolatedFileName = this.fileName != null ? this.fileName : (this.scopeClass != null ? this.scopeClass.getSimpleName() + ".css" : component.getClass().getSimpleName() + ".css");
        response.renderCSS((CharSequence)new PackageTextTemplate(interpolatedClass, interpolatedFileName).asString(this.substitutionMap), interpolatedClass.getName() + ":" + interpolatedFileName);
    }
}

