/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.smallmind.nutsnbolts.util.ArrayIterator;
import org.smallmind.nutsnbolts.util.IterableIterator;
import org.smallmind.wicket.component.google.visualization.ColumnDescription;
import org.smallmind.wicket.component.google.visualization.TableCell;
import org.smallmind.wicket.component.google.visualization.TableElement;
import org.smallmind.wicket.component.google.visualization.TableRow;
import org.smallmind.wicket.component.google.visualization.Value;

public class DataTable
extends TableElement {
    private ColumnDescription[] columnDescriptions;
    private ArrayList<TableRow> rows;

    public DataTable(List<ColumnDescription> columnDescriptionList) {
        this(columnDescriptionList.toArray(new ColumnDescription[columnDescriptionList.size()]));
    }

    public DataTable(ColumnDescription[] columnDescriptions) {
        this.columnDescriptions = columnDescriptions;
        this.rows = new ArrayList();
    }

    public int getColumnCount() {
        return this.columnDescriptions.length;
    }

    public ColumnDescription getColumnDescription(int index) {
        return this.columnDescriptions[index];
    }

    public Iterable<ColumnDescription> getColumnDescriptions() {
        return new ArrayIterator((Object[])this.columnDescriptions);
    }

    public synchronized TableRow createTableRow() {
        TableRow tableRow = new TableRow(this, new TableCell[this.columnDescriptions.length]);
        this.rows.add(tableRow);
        return tableRow;
    }

    public synchronized Iterable<TableRow> getRows() {
        return new IterableIterator(Collections.unmodifiableList(this.rows).iterator());
    }

    public synchronized TableRow getRow(int index) {
        return this.rows.get(index);
    }

    public synchronized TableCell getCell(int rowIndex, int cellIndex) {
        return this.rows.get(rowIndex).getCell(cellIndex);
    }

    public synchronized Value getValue(int rowIndex, int cellIndex) {
        return this.rows.get(rowIndex).getCell(cellIndex).getValue();
    }
}

