/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import java.util.Date;
import org.joda.time.DateTime;
import org.smallmind.wicket.component.google.visualization.TimeBasedValue;
import org.smallmind.wicket.component.google.visualization.ValueType;

public class DateValue
extends TimeBasedValue {
    private static DateValue NULL_VALUE = new DateValue(null);

    public static DateValue asNull() {
        return NULL_VALUE;
    }

    public static DateValue create(long milliseconds) {
        return new DateValue(new DateTime(milliseconds));
    }

    public static DateValue create(Long milliseconds) {
        return milliseconds == null ? NULL_VALUE : new DateValue(new DateTime((Object)milliseconds));
    }

    public static DateValue create(Date date) {
        return date == null ? NULL_VALUE : new DateValue(new DateTime((Object)date));
    }

    private DateValue(DateTime instant) {
        super(instant);
    }

    @Override
    public ValueType getType() {
        return ValueType.DATE;
    }

    public int getYear() {
        return this.getInstant().getYear();
    }

    public int getMonth() {
        return this.getInstant().getMonthOfYear() - 1;
    }

    public int getDay() {
        return this.getInstant().getDayOfMonth();
    }

    @Override
    public String forScript() {
        if (this.getInstant() == null) {
            return "null";
        }
        StringBuilder dateBuilder = new StringBuilder("new Date(");
        dateBuilder.append(this.getYear()).append(',').append(this.getMonth()).append(',').append(this.getDay()).append(",0,0,0,0)");
        return dateBuilder.toString();
    }
}

