/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import java.util.Date;
import org.joda.time.DateTime;
import org.smallmind.wicket.component.google.visualization.TimeBasedValue;
import org.smallmind.wicket.component.google.visualization.ValueType;

public class TimeOfDayValue
extends TimeBasedValue {
    private static TimeOfDayValue NULL_VALUE = new TimeOfDayValue(null);

    public static TimeOfDayValue asNull() {
        return NULL_VALUE;
    }

    public static TimeOfDayValue create(long milliseconds) {
        return new TimeOfDayValue(new DateTime(milliseconds));
    }

    public static TimeOfDayValue create(Long milliseconds) {
        return milliseconds == null ? NULL_VALUE : new TimeOfDayValue(new DateTime((Object)milliseconds));
    }

    public static TimeOfDayValue create(Date date) {
        return date == null ? NULL_VALUE : new TimeOfDayValue(new DateTime((Object)date));
    }

    private TimeOfDayValue(DateTime instant) {
        super(instant);
    }

    @Override
    public ValueType getType() {
        return ValueType.TIMEOFDAY;
    }

    public int getHour() {
        return this.getInstant().getHourOfDay();
    }

    public int getMinute() {
        return this.getInstant().getMinuteOfHour();
    }

    public int getSecond() {
        return this.getInstant().getSecondOfMinute();
    }

    public int getMillisecond() {
        return this.getInstant().getMillisOfSecond();
    }

    @Override
    public String forScript() {
        if (this.getInstant() == null) {
            return "null";
        }
        StringBuilder timeOfDayBuilder = new StringBuilder("[");
        timeOfDayBuilder.append(this.getHour()).append(',').append(this.getMinute()).append(',').append(this.getSecond()).append(',').append(this.getMillisecond()).append(']');
        return timeOfDayBuilder.toString();
    }
}

