/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import java.util.Date;
import org.smallmind.wicket.FormattedWicketRuntimeException;
import org.smallmind.wicket.component.google.visualization.BooleanValue;
import org.smallmind.wicket.component.google.visualization.DataTable;
import org.smallmind.wicket.component.google.visualization.DateTimeValue;
import org.smallmind.wicket.component.google.visualization.DateValue;
import org.smallmind.wicket.component.google.visualization.NumberValue;
import org.smallmind.wicket.component.google.visualization.TableRow;
import org.smallmind.wicket.component.google.visualization.TextValue;
import org.smallmind.wicket.component.google.visualization.TimeOfDayValue;
import org.smallmind.wicket.component.google.visualization.Value;
import org.smallmind.wicket.component.google.visualization.ValueType;

public class RowTransformer {
    private DataTable dataTable;

    public RowTransformer(DataTable dataTable) {
        this.dataTable = dataTable;
    }

    public void transform(TableRow tableRow, Object[] data) {
        if (this.dataTable.getColumnCount() != data.length) {
            throw new FormattedWicketRuntimeException("The data length(%d) does not match the expected length(%d)", data.length, this.dataTable.getColumnCount());
        }
        for (int count = 0; count < data.length; ++count) {
            tableRow.addCell(this.dataTable.getColumnDescription(count).createTableCell(this.convertValue(this.dataTable.getColumnDescription(count).getType(), data[count])));
        }
    }

    private Value convertValue(ValueType type, Object datum) {
        if (datum == null) {
            return type.asNull();
        }
        Class<?> datumClass = datum.getClass();
        if (Double.TYPE.equals(datumClass) || Double.class.equals(datumClass)) {
            switch (type) {
                case NUMBER: {
                    return NumberValue.create((Double)datum);
                }
                case TEXT: {
                    return TextValue.create(String.valueOf(datum));
                }
            }
        }
        if (Float.TYPE.equals(datumClass) || Float.class.equals(datumClass)) {
            switch (type) {
                case NUMBER: {
                    return NumberValue.create(((Float)datum).doubleValue());
                }
                case TEXT: {
                    return TextValue.create(String.valueOf(datum));
                }
            }
        }
        if (Long.TYPE.equals(datumClass) || Long.class.equals(datumClass)) {
            switch (type) {
                case NUMBER: {
                    return NumberValue.create(((Long)datum).doubleValue());
                }
                case TEXT: {
                    return TextValue.create(String.valueOf(datum));
                }
            }
        }
        if (Integer.TYPE.equals(datumClass) || Integer.class.equals(datumClass)) {
            switch (type) {
                case NUMBER: {
                    return NumberValue.create(((Integer)datum).doubleValue());
                }
                case TEXT: {
                    return TextValue.create(String.valueOf(datum));
                }
            }
        }
        if (Short.TYPE.equals(datumClass) || Short.class.equals(datumClass)) {
            switch (type) {
                case NUMBER: {
                    return NumberValue.create(((Short)datum).doubleValue());
                }
                case TEXT: {
                    return TextValue.create(String.valueOf(datum));
                }
            }
        }
        if (Byte.TYPE.equals(datumClass) || Byte.class.equals(datumClass)) {
            switch (type) {
                case NUMBER: {
                    return NumberValue.create(((Byte)datum).doubleValue());
                }
                case TEXT: {
                    return TextValue.create(String.valueOf(datum));
                }
            }
        }
        if (Boolean.TYPE.equals(datumClass) || Boolean.class.equals(datumClass)) {
            switch (type) {
                case BOOLEAN: {
                    return BooleanValue.create((Boolean)datum);
                }
                case TEXT: {
                    return TextValue.create(String.valueOf(datum));
                }
            }
        }
        if ((Character.TYPE.equals(datumClass) || Character.class.equals(datumClass)) && type.equals((Object)ValueType.TEXT)) {
            return TextValue.create(String.valueOf(datum));
        }
        if (datum instanceof String && type.equals((Object)ValueType.TEXT)) {
            return TextValue.create((String)datum);
        }
        if (datum instanceof Date) {
            switch (type) {
                case NUMBER: {
                    return NumberValue.create(((Date)datum).getTime());
                }
                case DATETIME: {
                    return DateTimeValue.create((Date)datum);
                }
                case DATE: {
                    return DateValue.create((Date)datum);
                }
                case TIMEOFDAY: {
                    return TimeOfDayValue.create((Date)datum);
                }
            }
        }
        if (datumClass.isEnum() && type.equals((Object)ValueType.TEXT)) {
            return TextValue.create(datum.toString());
        }
        throw new FormattedWicketRuntimeException("The data(%s) of class(%s) is not convertible to a value of type(%s)", datum.toString(), datumClass.getName(), type.name());
    }
}

