(function (B) {
  var A = {crosshair:{mode:null, color:"rgba(170, 0, 0, 0.80)", lineWidth:1}};

  function C (G) {
    var H = {x:-1, y:-1, locked:false};
    G.setCrosshair = function D (J) {
      if (!J) {
        H.x = -1
      }
      else {
        var I = G.getAxes();
        H.x = Math.max(0, Math.min(J.x != null ? I.xaxis.p2c(J.x) : I.x2axis.p2c(J.x2), G.width()));
        H.y = Math.max(0, Math.min(J.y != null ? I.yaxis.p2c(J.y) : I.y2axis.p2c(J.y2), G.height()))
      }
      G.triggerRedrawOverlay()
    };
    G.clearCrosshair = G.setCrosshair;
    G.lockCrosshair = function E (I) {
      if (I) {
        G.setCrosshair(I)
      }
      H.locked = true
    };
    G.unlockCrosshair = function F () {
      H.locked = false
    };
    G.hooks.bindEvents.push(function (J, I) {
      if (!J.getOptions().crosshair.mode) {
        return
      }
      I.mouseout(function () {
        if (H.x != -1) {
          H.x = -1;
          J.triggerRedrawOverlay()
        }
      });
      I.mousemove(function (K) {
        if (J.getSelection && J.getSelection()) {
          H.x = -1;
          return
        }
        if (H.locked) {
          return
        }
        var L = J.offset();
        H.x = Math.max(0, Math.min(K.pageX - L.left, J.width()));
        H.y = Math.max(0, Math.min(K.pageY - L.top, J.height()));
        J.triggerRedrawOverlay()
      })
    });
    G.hooks.drawOverlay.push(function (K, I) {
      var L = K.getOptions().crosshair;
      if (!L.mode) {
        return
      }
      var J = K.getPlotOffset();
      I.save();
      I.translate(J.left, J.top);
      if (H.x != -1) {
        I.strokeStyle = L.color;
        I.lineWidth = L.lineWidth;
        I.lineJoin = "round";
        I.beginPath();
        if (L.mode.indexOf("x") != -1) {
          I.moveTo(H.x, 0);
          I.lineTo(H.x, K.height())
        }
        if (L.mode.indexOf("y") != -1) {
          I.moveTo(0, H.y);
          I.lineTo(K.width(), H.y)
        }
        I.stroke()
      }
      I.restore()
    })
  }

  B.plot.plugins.push({init:C, options:A, name:"crosshair", version:"1.0"})
})(jQuery);