/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import org.smallmind.nutsnbolts.lang.TypeMismatchException;
import org.smallmind.wicket.component.google.visualization.Value;
import org.smallmind.wicket.component.google.visualization.ValueType;

public class BooleanValue
extends Value {
    private static BooleanValue NULL_VALUE = new BooleanValue(null);
    private Boolean logic;

    public static BooleanValue asNull() {
        return NULL_VALUE;
    }

    public static BooleanValue create(boolean logic) {
        return new BooleanValue(logic);
    }

    public static BooleanValue create(Boolean logic) {
        return logic == null ? NULL_VALUE : new BooleanValue(logic);
    }

    private BooleanValue(Boolean logic) {
        this.logic = logic;
    }

    public Boolean getBoolean() {
        return this.logic;
    }

    @Override
    public ValueType getType() {
        return ValueType.BOOLEAN;
    }

    @Override
    public boolean isNull() {
        return this.logic == null;
    }

    @Override
    public int compareTo(Value value) {
        if (!ValueType.BOOLEAN.equals((Object)value.getType())) {
            throw new TypeMismatchException();
        }
        if (this.isNull()) {
            return value.isNull() ? 0 : -1;
        }
        if (value.isNull()) {
            return 1;
        }
        return this.logic.compareTo(((BooleanValue)value).getBoolean());
    }

    @Override
    public String forScript() {
        return this.toString();
    }

    public String toString() {
        return this.logic == null ? "null" : this.logic.toString();
    }
}

