/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.model.dao;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.io.IClusterable;
import org.smallmind.persistence.Durable;
import org.smallmind.persistence.orm.ORMDao;

public class DaoBackedListSelectionModel<I extends Serializable & Comparable<I>, D extends Durable<I>>
implements Serializable,
IModel,
IDetachable,
IClusterable {
    private transient List<D> selectionList;
    private transient boolean attached = false;
    private ORMDao<I, D, ?> backingDao;
    private List<I> idList;

    public DaoBackedListSelectionModel(ORMDao<I, D, ?> backingDao) {
        this.backingDao = backingDao;
        this.idList = new LinkedList<I>();
    }

    public synchronized Object getObject() {
        if (!this.attached) {
            this.selectionList = new LinkedList<D>();
            for (Serializable id : this.idList) {
                this.selectionList.add(this.backingDao.get(id));
            }
            this.attached = true;
        }
        return this.selectionList;
    }

    public synchronized void setObject(Object obj) {
        this.selectionList = (List)obj;
    }

    public synchronized void detach() {
        if (this.attached) {
            this.idList.clear();
            for (Durable durable : this.selectionList) {
                this.idList.add(this.backingDao.getId(durable));
            }
            this.attached = false;
            this.selectionList = null;
        }
    }
}

