/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.behavior;

import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.util.template.PackageTextTemplate;

public class JavaScriptBehavior
extends Behavior {
    private Map<String, Object> substitutionMap;
    private Class scopeClass;
    private String fileName;

    public JavaScriptBehavior() {
        this(null, null, null);
    }

    public JavaScriptBehavior(String fileName) {
        this(null, fileName, null);
    }

    public JavaScriptBehavior(String fileName, Map<String, Object> substitutionMap) {
        this(null, fileName, substitutionMap);
    }

    public JavaScriptBehavior(Class scopeClass) {
        this(scopeClass, null, null);
    }

    public JavaScriptBehavior(Class scopeClass, Map<String, Object> substitutionMap) {
        this(scopeClass, null, substitutionMap);
    }

    public JavaScriptBehavior(Class scopeClass, String fileName, Map<String, Object> substitutionMap) {
        this.scopeClass = scopeClass;
        this.fileName = fileName;
        this.substitutionMap = substitutionMap;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        Class<?> interpolatedClass = this.scopeClass != null ? this.scopeClass : component.getClass();
        String interpolatedFileName = this.fileName == null ? component.getClass().getSimpleName() + ".js" : this.fileName;
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)new PackageTextTemplate(interpolatedClass, interpolatedFileName).asString(this.substitutionMap), (String)(interpolatedClass.getName() + ":" + interpolatedFileName)));
    }
}

