/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import org.smallmind.nutsnbolts.lang.TypeMismatchException;
import org.smallmind.wicket.component.google.visualization.CellFormatter;
import org.smallmind.wicket.component.google.visualization.TableCell;
import org.smallmind.wicket.component.google.visualization.TableElement;
import org.smallmind.wicket.component.google.visualization.Value;
import org.smallmind.wicket.component.google.visualization.ValueType;

public class ColumnDescription
extends TableElement {
    private CellFormatter cellFormatter;
    private ValueType type;
    private String id;
    private String label;

    public ColumnDescription(String id, ValueType type, String label) {
        this(id, type, label, null);
    }

    public ColumnDescription(String id, ValueType type, String label, CellFormatter cellFormatter) {
        this.id = id;
        this.type = type;
        this.label = label;
        this.cellFormatter = cellFormatter;
    }

    public String getId() {
        return this.id;
    }

    public ValueType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public CellFormatter getCellFormatter() {
        return this.cellFormatter;
    }

    public TableCell createTableCell(Value value) {
        return this.createTableCell(value, null);
    }

    public TableCell createTableCell(Value value, String formattedValue) {
        if (!this.type.equals((Object)value.getType())) {
            throw new TypeMismatchException("%s != %s", new Object[]{this.type, value.getType()});
        }
        return new TableCell(value, formattedValue == null && this.cellFormatter != null ? this.cellFormatter.format(value) : formattedValue);
    }
}

