/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import java.util.HashSet;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.smallmind.wicket.behavior.JavaScriptNamespaceBehavior;
import org.smallmind.wicket.component.google.visualization.ColumnDescription;
import org.smallmind.wicket.component.google.visualization.DataTable;
import org.smallmind.wicket.component.google.visualization.TableCell;
import org.smallmind.wicket.component.google.visualization.TableRow;
import org.smallmind.wicket.component.google.visualization.VisualizationInfo;

public abstract class VisualizationBorder
extends Border {
    private HashSet<String> panelIdSet = new HashSet();

    public VisualizationBorder(String id) {
        super(id);
        this.add(new Behavior[]{new JavaScriptNamespaceBehavior("SMALLMIND.visualization.flot." + this.getMarkupId())});
        this.add(new Behavior[]{new Behavior(){

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)("google.load('visualization', '" + VisualizationInfo.getVersion() + "');"), (String)VisualizationBorder.class.getName()));
            }
        }});
        Label scriptLabel = new Label("visualizationBorderScript", (IModel)new VisualizationBorderScriptModel());
        scriptLabel.setEscapeModelStrings(false);
        this.add(new Component[]{scriptLabel});
    }

    public abstract DataTable getDataTable();

    protected void addRenderingPanel(String id) {
        this.panelIdSet.add(id);
    }

    public void loadData(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)this.buildTableScript());
        target.appendJavaScript((CharSequence)("SMALLMIND.visualization.flot." + this.getMarkupId() + ".loadData();"));
    }

    private String buildTableScript() {
        StringBuilder scriptBuilder = new StringBuilder();
        int columnIndex = 0;
        DataTable dataTable = this.getDataTable();
        scriptBuilder.append("SMALLMIND.visualization.flot.").append(this.getMarkupId()).append('.').append("data = new google.visualization.DataTable();");
        for (ColumnDescription columnDescription : dataTable.getColumnDescriptions()) {
            scriptBuilder.append("SMALLMIND.visualization.flot.").append(this.getMarkupId()).append(".data.addColumn('").append(columnDescription.getType().getScriptVersion()).append("','").append(columnDescription.getLabel()).append("','").append(columnDescription.getId()).append("');");
            if (columnDescription.hasProperties()) {
                scriptBuilder.append("SMALLMIND.visualization.flot.").append(this.getMarkupId()).append(".data.setColumnProperties(").append(columnIndex).append(',').append(columnDescription.getPropertiesAsJson()).append(");");
            }
            ++columnIndex;
        }
        for (TableRow tableRow : dataTable.getRows()) {
            StringBuilder rowBuilder = new StringBuilder("[");
            for (TableCell tableCell : tableRow.getCells()) {
                if (rowBuilder.length() > 1) {
                    rowBuilder.append(',');
                }
                if (tableCell.getFormattedValue() == null && !tableCell.hasProperties()) {
                    rowBuilder.append(tableCell.getValue().forScript());
                    continue;
                }
                rowBuilder.append("{v: ").append(tableCell.getValue().forScript());
                if (tableCell.getFormattedValue() != null) {
                    rowBuilder.append(",f: '").append(tableCell.getFormattedValue()).append('\'');
                }
                if (tableCell.hasProperties()) {
                    rowBuilder.append(",p: ").append(tableCell.getPropertiesAsJson());
                }
                rowBuilder.append('}');
            }
            rowBuilder.append("]");
            scriptBuilder.append("SMALLMIND.visualization.flot.").append(this.getMarkupId()).append(".data.addRow(").append((CharSequence)rowBuilder).append(");");
        }
        return scriptBuilder.toString();
    }

    private class VisualizationBorderScriptModel
    extends AbstractReadOnlyModel<String> {
        private VisualizationBorderScriptModel() {
        }

        public String getObject() {
            StringBuilder scriptBuilder = new StringBuilder();
            scriptBuilder.append(VisualizationBorder.this.buildTableScript());
            scriptBuilder.append("SMALLMIND.visualization.flot.").append(VisualizationBorder.this.getMarkupId()).append(".loadData  = function () {");
            for (String panelId : VisualizationBorder.this.panelIdSet) {
                scriptBuilder.append("SMALLMIND.visualization.flot.").append(panelId).append(".drawChart(").append("SMALLMIND.visualization.flot.").append(VisualizationBorder.this.getMarkupId()).append('.').append("data);");
            }
            scriptBuilder.append("};");
            scriptBuilder.append("google.setOnLoadCallback(").append("SMALLMIND.visualization.flot.").append(VisualizationBorder.this.getMarkupId()).append(".loadData);");
            VisualizationBorder.this.panelIdSet.clear();
            return scriptBuilder.toString();
        }
    }
}

