/*
 * Copyright (c) 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 David Berkman
 * 
 * This file is part of the SmallMind Code Project.
 * 
 * The SmallMind Code Project is free software, you can redistribute
 * it and/or modify it under the terms of GNU Affero General Public
 * License as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * The SmallMind Code Project is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the the GNU Affero General Public
 * License, along with the SmallMind Code Project. If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * Additional permission under the GNU Affero GPL version 3 section 7
 * ------------------------------------------------------------------
 * If you modify this Program, or any covered work, by linking or
 * combining it with other code, such other code is not for that reason
 * alone subject to any of the requirements of the GNU Affero GPL
 * version 3.
 */
package org.smallmind.wicket.model;

import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.Model;

public class FormattedResourceModel extends AbstractReadOnlyModel {

  private Component component;
  private Object[] args;
  private String key;

  public FormattedResourceModel (Component component, String key, Object... args) {

    this.component = component;
    this.key = key;
    this.args = args;
  }

  public Object getObject () {

    if ((args == null) || args.length == 0) {
      return component.getApplication().getResourceSettings().getLocalizer().getString(key, component);
    }

    Object[] unwrappedArgs = new Object[args.length];

    for (int count = 0; count < args.length; count++) {
      if (args[count] instanceof Model) {
        unwrappedArgs[count] = ((Model)args[count]).getObject();
      }
      else {
        unwrappedArgs[count] = args[count];
      }
    }

    return MessageFormat.format(component.getApplication().getResourceSettings().getLocalizer().getString(key, component), unwrappedArgs);
  }

  public String toString () {

    return getObject().toString();
  }
}
