/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import org.smallmind.nutsnbolts.lang.TypeMismatchException;
import org.smallmind.wicket.component.google.visualization.Value;
import org.smallmind.wicket.component.google.visualization.ValueType;

public class TextValue
extends Value {
    private static TextValue NULL_VALUE = new TextValue(null);
    private String text;

    public static TextValue asNull() {
        return NULL_VALUE;
    }

    public static TextValue create(String text) {
        return text == null ? NULL_VALUE : new TextValue(text);
    }

    private TextValue(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public ValueType getType() {
        return ValueType.TEXT;
    }

    @Override
    public boolean isNull() {
        return this.text == null;
    }

    @Override
    public int compareTo(Value value) {
        if (!ValueType.TEXT.equals((Object)value.getType())) {
            throw new TypeMismatchException();
        }
        if (this.isNull()) {
            return value.isNull() ? 0 : -1;
        }
        if (value.isNull()) {
            return 1;
        }
        return this.text.compareTo(((TextValue)value).getText());
    }

    @Override
    public String forScript() {
        return this.text == null ? "null" : '\'' + this.text + '\'';
    }

    public String toString() {
        return this.text == null ? "null" : this.text;
    }
}

