/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.google.visualization;

import java.io.Serializable;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.smallmind.wicket.FormattedWicketRuntimeException;
import org.smallmind.wicket.behavior.JavaScriptNamespaceBehavior;
import org.smallmind.wicket.component.google.visualization.VisualizationBorder;

public class VisualizationPanel
extends Panel {
    public VisualizationPanel(String id, String jsonClass) {
        this(id, null, jsonClass, null);
    }

    public VisualizationPanel(String id, String jsonClass, String options) {
        this(id, null, jsonClass, options);
    }

    public VisualizationPanel(String id, IModel<String> javascriptModel, String jsonClass) {
        this(id, javascriptModel, jsonClass, null);
    }

    public VisualizationPanel(String id, IModel<String> javascriptModel, String jsonClass, String options) {
        super(id);
        String divId = UUID.randomUUID().toString();
        this.add(new Behavior[]{new JavaScriptNamespaceBehavior("SMALLMIND.visualization.flot." + this.getMarkupId())});
        Label divLabel = new Label("visualizationDiv", (IModel)new Model((Serializable)((Object)("<div id=\"" + divId + "\"></div>"))));
        divLabel.setEscapeModelStrings(false);
        Label scriptLabel = new Label("visualizationPanelScript", (IModel)new VisualizationPanelScriptModel(javascriptModel, divId, jsonClass, options));
        scriptLabel.setEscapeModelStrings(false);
        this.add(new Component[]{divLabel});
        this.add(new Component[]{scriptLabel});
    }

    public String getJavascriptDataVariable() {
        return "data";
    }

    private class VisualizationPanelScriptModel
    extends AbstractReadOnlyModel<String> {
        private IModel<String> javascriptModel;
        private String divId;
        private String jsonClass;
        private String options;

        public VisualizationPanelScriptModel(IModel<String> javascriptModel, String divId, String jsonClass, String options) {
            this.javascriptModel = javascriptModel;
            this.divId = divId;
            this.jsonClass = jsonClass;
            this.options = options;
        }

        public String getObject() {
            StringBuilder scriptBuilder = new StringBuilder();
            VisualizationBorder visualizationBorder = (VisualizationBorder)((Object)VisualizationPanel.this.findParent(VisualizationBorder.class));
            if (visualizationBorder == null) {
                throw new FormattedWicketRuntimeException("%s(%s) is not within the context of a %s", VisualizationPanel.class.getSimpleName(), VisualizationPanel.this.getMarkupId(), VisualizationBorder.class.getSimpleName());
            }
            scriptBuilder.append("SMALLMIND.visualization.flot.").append(VisualizationPanel.this.getMarkupId()).append(".drawChart  = function (data) {");
            if (this.javascriptModel != null) {
                scriptBuilder.append((String)this.javascriptModel.getObject());
            }
            scriptBuilder.append("var chart = new ").append(this.jsonClass).append("(document.getElementById('").append(this.divId).append("'));");
            scriptBuilder.append("chart.draw(").append(VisualizationPanel.this.getJavascriptDataVariable()).append(", ").append(this.options == null ? "{}" : this.options).append(");");
            scriptBuilder.append('}');
            visualizationBorder.addRenderingPanel(VisualizationPanel.this.getMarkupId());
            return scriptBuilder.toString();
        }
    }
}

