/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.resource;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.wicket.markup.html.image.resource.RenderedDynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.smallmind.swing.SmallMindGrayFilter;
import org.smallmind.wicket.resource.ImageType;

public class GrayFilterImageResource
extends RenderedDynamicImageResource {
    Image grayImage;

    public GrayFilterImageResource(URL imageUrl, ImageType imageType) throws IOException {
        this(ImageIO.read(imageUrl), imageType);
    }

    private GrayFilterImageResource(BufferedImage image, ImageType imageType) {
        super(image.getWidth(), image.getHeight(), imageType.getFormat());
        this.setType(2);
        this.grayImage = SmallMindGrayFilter.createDisabledImage((Image)image);
    }

    protected boolean render(Graphics2D graphics, IResource.Attributes attributes) {
        graphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics.drawImage(this.grayImage, 0, 0, this.getWidth(), this.getHeight(), null);
        return true;
    }
}

