/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.util;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.util.template.TextTemplate;
import org.smallmind.nutsnbolts.freemarker.ClassPathTemplateLoader;
import org.smallmind.wicket.util.StaticTextTemplate;

public class FreeMarkerPackageTextTemplate
extends TextTemplate {
    private static ConcurrentHashMap<Class<?>, Configuration> CONFIG_MAP = new ConcurrentHashMap();
    private Template freeMarkerTemplate;

    public FreeMarkerPackageTextTemplate(Class<?> scopeClass, String fileName) {
        Configuration freemarkerConf = CONFIG_MAP.get(scopeClass);
        if (freemarkerConf == null) {
            freemarkerConf = new Configuration();
            freemarkerConf.setTagSyntax(2);
            freemarkerConf.setTemplateLoader((TemplateLoader)new ClassPathTemplateLoader(scopeClass, true));
            CONFIG_MAP.put(scopeClass, freemarkerConf);
        }
        try {
            this.freeMarkerTemplate = freemarkerConf.getTemplate(fileName == null ? scopeClass.getSimpleName() + ".js" : fileName);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    public String getString() {
        return this.freeMarkerTemplate.toString();
    }

    public TextTemplate interpolate(Map<String, ?> variables) {
        StringWriter templateWriter = new StringWriter();
        try {
            this.freeMarkerTemplate.process(variables, (Writer)templateWriter);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return new StaticTextTemplate(templateWriter.toString());
    }
}

