/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StyleAttribute {
    private HashMap<String, String> styleMap = new HashMap();

    public StyleAttribute() {
    }

    public StyleAttribute(String style) {
        if (style != null) {
            for (String styleSegment : style.split(";", -1)) {
                int colonPos = styleSegment.indexOf(58);
                if (colonPos < 0) {
                    throw new IllegalArgumentException(style);
                }
                this.styleMap.put(styleSegment.substring(0, colonPos).trim(), styleSegment.substring(colonPos + 1).trim());
            }
        }
    }

    public synchronized String[] getKeys() {
        Set<String> keySet = this.styleMap.keySet();
        String[] keys = new String[keySet.size()];
        keySet.toArray(keys);
        return keys;
    }

    public synchronized String getAttribute(String styleKey) {
        return this.styleMap.get(styleKey);
    }

    public synchronized void putAttribute(String styleKey, String styleValue) {
        this.styleMap.put(styleKey, styleValue);
    }

    public synchronized String removeAttribute(String styleKey) {
        return this.styleMap.remove(styleKey);
    }

    public synchronized boolean isEmpty() {
        return this.styleMap.isEmpty();
    }

    public synchronized String getStyle() {
        StringBuilder styleBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.styleMap.entrySet()) {
            if (styleBuilder.length() > 0) {
                styleBuilder.append(';');
            }
            styleBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
        }
        return styleBuilder.toString();
    }
}

