/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.behavior.freemarker;

import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.smallmind.wicket.util.FreeMarkerPackageTextTemplate;

public class FreeMarkerJavaScriptBehavior
extends Behavior {
    private final Map<String, Object> rootModel;
    private final Class<?> scopeClass;
    private final String fileName;

    public FreeMarkerJavaScriptBehavior(Map<String, Object> rootModel) {
        this(null, null, rootModel);
    }

    public FreeMarkerJavaScriptBehavior(String fileName, Map<String, Object> rootModel) {
        this(null, fileName, rootModel);
    }

    public FreeMarkerJavaScriptBehavior(Class<?> scopeClass, String fileName, Map<String, Object> rootModel) {
        this.scopeClass = scopeClass;
        this.fileName = fileName;
        this.rootModel = rootModel;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        Class<?> interpolatedClass = this.scopeClass != null ? this.scopeClass : component.getClass();
        String interpolatedFileName = this.fileName == null ? component.getClass().getSimpleName() + ".js" : this.fileName;
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)new FreeMarkerPackageTextTemplate(interpolatedClass, interpolatedFileName).asString(this.rootModel), (String)(interpolatedClass.getName() + ":" + interpolatedFileName)));
    }
}

