/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.link;

import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public class ExternalLink
extends AbstractLink {
    private final IModel<String> label;
    private final Target target;

    public ExternalLink(String id, IModel<String> hrefModel, Target target, IModel<String> labelModel) {
        super(id);
        this.target = target;
        this.setDefaultModel(this.wrap(hrefModel));
        this.label = this.wrap(labelModel);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
            tag.put("href", Strings.replaceAll((CharSequence)this.getDefaultModelObjectAsString(), (CharSequence)"&", (CharSequence)"&amp;"));
            tag.put("target", (CharSequence)this.target.asAttribute());
        } else {
            tag.put("onclick", (CharSequence)(this.target.asWindow() + "='" + this.getDefaultModelObjectAsString() + "';return false;"));
        }
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        if (!this.isLinkEnabled() && this.getBeforeDisabledLink() != null) {
            this.getResponse().write((CharSequence)this.getBeforeDisabledLink());
        }
        if (this.label != null && this.label.getObject() != null) {
            this.replaceComponentTagBody(markupStream, openTag, this.getDefaultModelObjectAsString(this.label.getObject()));
        } else {
            super.onComponentTagBody(markupStream, openTag);
        }
        if (!this.isLinkEnabled() && this.getAfterDisabledLink() != null) {
            this.getResponse().write((CharSequence)this.getAfterDisabledLink());
        }
    }

    public static enum Target {
        BLANK("_blank", null),
        PARENT("_parent", "window.parent.location"),
        SELF("_self", "window.location"),
        TOP("_top", "window.top.location");

        private final String attribute;
        private final String window;

        private Target(String attribute, String window) {
            this.attribute = attribute;
            this.window = window;
        }

        public String asAttribute() {
            return this.attribute;
        }

        public String asWindow() {
            if (this.window == null) {
                throw new WicketRuntimeException("Can not set the current 'window.blank' location via script");
            }
            return this.window;
        }
    }
}

