/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.tabs;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.http.WebApplication;
import org.smallmind.wicket.behavior.CssBehavior;
import org.smallmind.wicket.component.tabs.SelectionChangedCallback;
import org.smallmind.wicket.component.tabs.Tab;
import org.smallmind.wicket.skin.SkinManager;

public class TabPanel
extends Panel {
    private final LinkedList<Tab> tabList;
    private final WebMarkupContainer tabContents;
    private SelectionChangedCallback selectionChangedCallback;
    private int selectedIndex = 0;

    public TabPanel(String id, SkinManager skinManager) {
        this(id, 0, skinManager);
    }

    public TabPanel(String id, int selectedIndex, SkinManager skinManager) {
        super(id);
        this.selectedIndex = selectedIndex;
        this.tabList = new LinkedList();
        this.setOutputMarkupId(true);
        this.add(new Component[]{new TabListView("tabCell", this.tabList)});
        this.tabContents = new WebMarkupContainer("tabContents");
        this.tabContents.setOutputMarkupId(true);
        this.add(new Component[]{this.tabContents});
        Properties cssProperties = skinManager.getProperties((WebApplication)this.getApplication(), TabPanel.class);
        cssProperties.put("contextpath", ((WebApplication)this.getApplication()).getServletContext().getContextPath());
        this.add(new Behavior[]{new CssBehavior(Tab.class, "Tab.css", cssProperties)});
    }

    public synchronized TabPanel setSelectionChangedCallback(SelectionChangedCallback selectionChangedCallback) {
        this.selectionChangedCallback = selectionChangedCallback;
        return this;
    }

    public synchronized TabPanel addTab(ITab tab) {
        if (this.tabList.size() == this.selectedIndex) {
            this.tabContents.add(new Component[]{tab.getPanel("tabPanel")});
        }
        this.tabList.add(new Tab("tab", this, tab, this.tabList.size(), this.tabList.size() == this.selectedIndex));
        return this;
    }

    public synchronized void setSelectedIndex(AjaxRequestTarget target, int index) {
        target.add(new Component[]{this.tabList.get(this.selectedIndex).setSelected(false)});
        Tab selectedTab = this.tabList.get(index).setSelected(true);
        this.tabContents.replace((Component)selectedTab.getPanel("tabPanel"));
        target.add(new Component[]{this.tabContents});
        target.add(new Component[]{selectedTab});
        this.selectedIndex = index;
        if (this.selectionChangedCallback != null) {
            this.selectionChangedCallback.onSelectionChanged(target, index);
        }
    }

    private class TabListView
    extends ListView {
        public TabListView(String id, List<Tab> tabList) {
            super(id, tabList);
            this.setReuseItems(true);
        }

        protected void populateItem(ListItem listItem) {
            listItem.add(new Component[]{(Tab)((Object)listItem.getModelObject())});
        }
    }
}

