/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.feeback;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebApplication;
import org.smallmind.wicket.behavior.CssBehavior;
import org.smallmind.wicket.model.VisibilityModel;
import org.smallmind.wicket.skin.SkinManager;

public class FeedbackPanel
extends Panel {
    public FeedbackPanel(String id, SkinManager skinManager) {
        super(id);
        FeedbackMessageListModel feedbackMessageListModel = new FeedbackMessageListModel();
        this.add(new Component[]{new FeedbackListView("feedbackRow", feedbackMessageListModel)});
        this.add(new Behavior[]{new AttributeAppender("style", (IModel)new FeedbackDisplayModel(feedbackMessageListModel), ";")});
        Properties cssProperties = skinManager.getProperties((WebApplication)this.getApplication(), FeedbackPanel.class);
        this.add(new Behavior[]{new CssBehavior(cssProperties)});
    }

    private static class FeedbackDisplayModel
    extends VisibilityModel {
        private final FeedbackMessageListModel feedbackMessageListModel;

        public FeedbackDisplayModel(FeedbackMessageListModel feedbackMessageListModel) {
            this.feedbackMessageListModel = feedbackMessageListModel;
        }

        @Override
        public boolean isVisible() {
            return !this.feedbackMessageListModel.getObject().isEmpty();
        }
    }

    private static class FeedbackMessageListModel
    implements IModel<List<FeedbackMessage>> {
        private FeedbackMessageListModel() {
        }

        public List<FeedbackMessage> getObject() {
            return Session.get().getFeedbackMessages().messages(null);
        }
    }

    private static class FeedbackListView
    extends ListView<FeedbackMessage> {
        public FeedbackListView(String id, IModel<List<FeedbackMessage>> messageListModel) {
            super(id, messageListModel);
        }

        protected void populateItem(ListItem listItem) {
            listItem.add(new Component[]{new Label("messageLabel", (Serializable)((Object)((FeedbackMessage)listItem.getModelObject()).getMessage().toString()))});
        }
    }
}

