/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.component.tabs;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.smallmind.wicket.component.tabs.TabPanel;

public class Tab
extends Panel {
    private final TabPanel tabPanel;
    private final ITab tab;
    private final WebMarkupContainer tabSkin;
    private final int index;
    private boolean selected;

    public Tab(String id, TabPanel tabPanel, ITab tab, int index, boolean selected) {
        super(id);
        this.tabPanel = tabPanel;
        this.tab = tab;
        this.index = index;
        this.selected = selected;
        this.setOutputMarkupId(true);
        Label innerSpan = new Label("innerSpan", tab.getTitle());
        WebMarkupContainer outerSpan = new WebMarkupContainer("outerSpan");
        outerSpan.add(new Component[]{innerSpan});
        Component[] componentArray = new Component[1];
        this.tabSkin = new WebMarkupContainer("tabSkin");
        componentArray[0] = this.tabSkin;
        this.add(componentArray);
        this.tabSkin.setOutputMarkupId(true);
        this.tabSkin.add(new Component[]{outerSpan});
        this.tabSkin.add(new Behavior[]{new AttributeModifier("class", (IModel)new TabClassModel())});
        this.tabSkin.add(new Behavior[]{new AttributeModifier("selected", (IModel)new TabSelectedModel())});
        this.tabSkin.add(new Behavior[]{new OnClickAjaxEventBehavior()});
    }

    public String getInnerMarkupId() {
        return this.tabSkin.getMarkupId();
    }

    public WebMarkupContainer getPanel(String id) {
        return this.tab.getPanel(id);
    }

    public synchronized boolean isSelected() {
        return this.selected;
    }

    public synchronized Tab setSelected(boolean selected) {
        this.selected = selected;
        return this;
    }

    private class OnClickAjaxEventBehavior
    extends AjaxEventBehavior {
        public OnClickAjaxEventBehavior() {
            super("onClick");
        }

        protected void onEvent(AjaxRequestTarget target) {
            Tab.this.tabPanel.setSelectedIndex(target, Tab.this.index);
        }
    }

    private class TabSelectedModel
    implements IModel<String> {
        private TabSelectedModel() {
        }

        public String getObject() {
            return Tab.this.isSelected() ? "selected" : null;
        }
    }

    private class TabClassModel
    implements IModel<String> {
        private TabClassModel() {
        }

        public String getObject() {
            return Tab.this.isSelected() ? "tabselected" : "tabstandard";
        }
    }
}

