/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.model.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.wicket.model.IModel;

public class FreeMarkerModel
implements IModel<String> {
    private static final Configuration FREEMARKER_CONF = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    public Template template;
    public Map<String, Object> rootMap;

    public FreeMarkerModel(String templateText, Map<String, Object> rootMap) throws IOException {
        this.rootMap = rootMap;
        this.template = new Template(null, (Reader)new StringReader(templateText), FREEMARKER_CONF);
    }

    public String getObject() {
        StringWriter templateWriter = new StringWriter();
        try {
            this.template.process(this.rootMap, (Writer)templateWriter);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return templateWriter.toString();
    }

    static {
        FREEMARKER_CONF.setTagSyntax(2);
    }
}

