/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.wicket.validator;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class PasswordComplexityValidator
implements IValidator<String> {
    private static final PasswordComplexityValidator STATIC_INSTANCE = new PasswordComplexityValidator();

    public static PasswordComplexityValidator getInstance() {
        return STATIC_INSTANCE;
    }

    public void validate(IValidatable<String> iValidatable) {
        int digitCount = 0;
        int punctuationCount = 0;
        String password = (String)iValidatable.getValue();
        if (password.length() < 6) {
            this.error(iValidatable, "error.password.complexity.length");
        }
        for (int count = 0; count < password.length(); ++count) {
            if (Character.isDigit(password.charAt(count))) {
                ++digitCount;
                continue;
            }
            if (Character.isLetter(password.charAt(count))) continue;
            ++punctuationCount;
        }
        if (digitCount < 1 && punctuationCount < 1) {
            this.error(iValidatable, "error.password.complexity.safety");
        }
    }

    public void error(IValidatable<?> validatable, String resourceKey) {
        if (resourceKey == null) {
            throw new IllegalArgumentException("Argument [[resourceKey]] cannot be null");
        }
        this.error(validatable, resourceKey, new HashMap<String, Object>());
    }

    public void error(IValidatable<?> validatable, String resourceKey, Map<String, Object> vars) {
        if (validatable == null) {
            throw new IllegalArgumentException("Argument [[validatable]] cannot be null");
        }
        if (vars == null) {
            throw new IllegalArgumentException("Argument [[vars]] cannot be null");
        }
        if (resourceKey == null) {
            throw new IllegalArgumentException("Argument [[resourceKey]] cannot be null");
        }
        ValidationError error = new ValidationError().addKey(resourceKey);
        String defaultKey = Classes.simpleName(this.getClass());
        if (!resourceKey.equals(defaultKey)) {
            error.addKey(defaultKey);
        }
        error.setVariables(vars);
        validatable.error((IValidationError)error);
    }
}

