/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.sleuth.maven.surefire;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;

public class ForwardingPrintStream
extends PrintStream {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final ConsoleOutputReceiver consoleOutputReceiver;
    private final boolean isStdOut;

    ForwardingPrintStream(ConsoleOutputReceiver consoleOutputReceiver, boolean isStdOut) {
        super(new ByteArrayOutputStream());
        this.consoleOutputReceiver = consoleOutputReceiver;
        this.isStdOut = isStdOut;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.consoleOutputReceiver.writeTestOutput(buf, off, len, this.isStdOut);
    }

    @Override
    public void write(byte[] b) {
        this.consoleOutputReceiver.writeTestOutput(b, 0, b.length, this.isStdOut);
    }

    @Override
    public void write(int b) {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void println(String s) {
        byte[] bytes = ((s == null ? "null" : s) + LINE_SEPARATOR).getBytes();
        this.consoleOutputReceiver.writeTestOutput(bytes, 0, bytes.length, this.isStdOut);
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

