/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.sleuth.maven.surefire;

import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.sleuth.maven.surefire.SleuthStackTraceWriter;
import org.smallmind.sleuth.runner.event.ErrorSleuthEvent;
import org.smallmind.sleuth.runner.event.FailureSleuthEvent;
import org.smallmind.sleuth.runner.event.FatalSleuthEvent;
import org.smallmind.sleuth.runner.event.MootSleuthEvent;
import org.smallmind.sleuth.runner.event.SkippedSleuthEvent;
import org.smallmind.sleuth.runner.event.SleuthEvent;
import org.smallmind.sleuth.runner.event.SleuthEventListener;
import org.smallmind.sleuth.runner.event.SuccessSleuthEvent;

public class SurefireSleuthEventListener
implements SleuthEventListener {
    private RunListener runListener;
    private Throwable throwable;

    public SurefireSleuthEventListener(RunListener runListener) {
        this.runListener = runListener;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void handle(SleuthEvent event) {
        switch (event.getType()) {
            case START: {
                this.runListener.testStarting((ReportEntry)new SimpleReportEntry(event.getClassName(), event.getMethodName()));
                break;
            }
            case SUCCESS: {
                this.runListener.testSucceeded((ReportEntry)new SimpleReportEntry(event.getClassName(), event.getMethodName(), Integer.valueOf((int)((SuccessSleuthEvent)event).getElapsed())));
                break;
            }
            case FAILURE: {
                this.runListener.testFailed((ReportEntry)new SimpleReportEntry(event.getClassName(), event.getMethodName(), (StackTraceWriter)new SleuthStackTraceWriter(event.getClassName(), event.getMethodName(), ((FailureSleuthEvent)event).getThrowable()), Integer.valueOf((int)((FailureSleuthEvent)event).getElapsed())));
                break;
            }
            case ERROR: {
                this.runListener.testError((ReportEntry)new SimpleReportEntry(event.getClassName(), event.getMethodName(), (StackTraceWriter)new SleuthStackTraceWriter(event.getClassName(), event.getMethodName(), ((ErrorSleuthEvent)event).getThrowable()), Integer.valueOf((int)((ErrorSleuthEvent)event).getElapsed())));
                break;
            }
            case SKIPPED: {
                this.runListener.testSkipped((ReportEntry)new SimpleReportEntry(event.getClassName(), event.getMethodName(), ((SkippedSleuthEvent)event).getMessage()));
                break;
            }
            case MOOT: {
                this.runListener.testAssumptionFailure((ReportEntry)new SimpleReportEntry(event.getClassName(), event.getMethodName(), (StackTraceWriter)new SleuthStackTraceWriter(event.getClassName(), event.getMethodName(), ((MootSleuthEvent)event).getThrowable()), Integer.valueOf((int)((MootSleuthEvent)event).getElapsed())));
                break;
            }
            case FATAL: {
                this.throwable = ((FatalSleuthEvent)event).getThrowable();
                this.runListener.testExecutionSkippedByUser();
                break;
            }
            default: {
                throw new UnknownSwitchCaseException(event.getType().name(), new Object[0]);
            }
        }
    }
}

