/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.sleuth.maven.surefire;

import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.TestSetReportEntry;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.TestsToRun;
import org.smallmind.sleuth.maven.surefire.ForwardingPrintStream;
import org.smallmind.sleuth.maven.surefire.SurefireSleuthEventListener;
import org.smallmind.sleuth.runner.SleuthRunner;
import org.smallmind.sleuth.runner.event.SleuthEventListener;

public class SleuthProvider
extends AbstractProvider {
    private final ProviderParameters providerParameters;
    private final SleuthRunner sleuthRunner = new SleuthRunner();
    private TestsToRun testsToRun;

    public SleuthProvider(ProviderParameters providerParameters) {
        this.providerParameters = providerParameters;
    }

    public Iterable<Class<?>> getSuites() {
        this.testsToRun = this.providerParameters.getScanResult().applyFilter(null, this.providerParameters.getTestClassLoader());
        return this.testsToRun;
    }

    public void cancel() {
        this.sleuthRunner.cancel();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        RunListener runListener = reporterFactory.createReporter();
        String[] groups = null;
        System.setOut(new ForwardingPrintStream((ConsoleOutputReceiver)runListener, true));
        System.setErr(new ForwardingPrintStream((ConsoleOutputReceiver)runListener, false));
        String groupsParameter = (String)this.providerParameters.getProviderProperties().get("groups");
        if (groupsParameter != null && !groupsParameter.isEmpty()) {
            String[] parameterElements = groupsParameter.split(",", -1);
            int index = 0;
            groups = new String[parameterElements.length];
            for (String parameterElement : parameterElements) {
                groups[index++] = parameterElement;
            }
        }
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.providerParameters.getScanResult().applyFilter(null, this.providerParameters.getTestClassLoader()));
        }
        SurefireSleuthEventListener sleuthEventListener = new SurefireSleuthEventListener(runListener);
        this.sleuthRunner.addListener((SleuthEventListener)sleuthEventListener);
        long startMilliseconds = System.currentTimeMillis();
        runListener.testSetStarting((TestSetReportEntry)new SimpleReportEntry("Sleuth Tests", "Test Assay", "test set starting"));
        this.sleuthRunner.execute(this.providerParameters.getProviderProperties().get("threadCount") == null ? 0 : Integer.parseInt((String)this.providerParameters.getProviderProperties().get("threadCount")), groups, (Iterable)this.testsToRun);
        runListener.testSetCompleted((TestSetReportEntry)new SimpleReportEntry("Sleuth Tests", "Test Assay", Integer.valueOf((int)(System.currentTimeMillis() - startMilliseconds))));
        RunResult runResult = reporterFactory.close();
        if (sleuthEventListener.getThrowable() != null) {
            throw new TestSetFailedException(sleuthEventListener.getThrowable());
        }
        return runResult;
    }
}

