/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.sleuth.maven.surefire;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.maven.surefire.api.report.OutputReportEntry;
import org.apache.maven.surefire.api.report.TestOutputReceiver;
import org.smallmind.sleuth.maven.surefire.SleuthReportEntry;

public class ForwardingPrintStream
extends PrintStream {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final TestOutputReceiver<OutputReportEntry> testOutputReceiver;
    private final boolean stdOut;

    ForwardingPrintStream(TestOutputReceiver<OutputReportEntry> testOutputReceiver, boolean stdOut) {
        super(new ByteArrayOutputStream());
        this.testOutputReceiver = testOutputReceiver;
        this.stdOut = stdOut;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.testOutputReceiver.writeTestOutput((OutputReportEntry)new SleuthReportEntry(new String(buf, off, len), this.stdOut));
    }

    @Override
    public void write(byte[] buf) {
        this.testOutputReceiver.writeTestOutput((OutputReportEntry)new SleuthReportEntry(new String(buf), this.stdOut));
    }

    @Override
    public void write(int b) {
        this.testOutputReceiver.writeTestOutput((OutputReportEntry)new SleuthReportEntry(new String(new byte[]{(byte)b}), this.stdOut));
    }

    @Override
    public void println(String s) {
        byte[] bytes = ((s == null ? "null" : s) + LINE_SEPARATOR).getBytes(StandardCharsets.UTF_8);
        this.testOutputReceiver.writeTestOutput((OutputReportEntry)new SleuthReportEntry(new String(bytes), this.stdOut));
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

