/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.sleuth.maven.surefire;

import java.util.Arrays;
import org.apache.maven.surefire.api.provider.AbstractProvider;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.report.ReporterException;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.TestsToRun;
import org.smallmind.nutsnbolts.util.AnsiColor;
import org.smallmind.sleuth.maven.surefire.ForwardingPrintStream;
import org.smallmind.sleuth.maven.surefire.SleuthOutputReceiver;
import org.smallmind.sleuth.maven.surefire.SurefireSleuthEventListener;
import org.smallmind.sleuth.runner.SleuthRunner;
import org.smallmind.sleuth.runner.event.SleuthEventListener;

public class SleuthProvider
extends AbstractProvider {
    private final ProviderParameters providerParameters;
    private final SleuthRunner sleuthRunner = new SleuthRunner();
    private TestsToRun testsToRun;

    public SleuthProvider(ProviderParameters providerParameters) {
        this.providerParameters = providerParameters;
    }

    public Iterable<Class<?>> getSuites() {
        this.testsToRun = this.providerParameters.getScanResult().applyFilter(null, this.providerParameters.getTestClassLoader());
        return this.testsToRun;
    }

    public void cancel() {
        this.sleuthRunner.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        RunResult runResult;
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        TestReportListener reportListener = reporterFactory.createTestReportListener();
        try {
            SleuthOutputReceiver sleuthOutputReceiver = new SleuthOutputReceiver((TestReportListener<TestOutputReportEntry>)reportListener, RunMode.NORMAL_RUN);
            boolean stopOnError = true;
            boolean stopOnFailure = true;
            int threadCount = 0;
            int testIndex = 0;
            System.setOut(new ForwardingPrintStream(sleuthOutputReceiver, true));
            System.setErr(new ForwardingPrintStream(sleuthOutputReceiver, false));
            Object[] groups = this.parseGroups(System.getProperty("groups"));
            if (groups == null) {
                groups = this.parseGroups((String)this.providerParameters.getProviderProperties().get("groups"));
            }
            if (this.testsToRun == null) {
                this.testsToRun = forkTestSet instanceof TestsToRun ? (TestsToRun)forkTestSet : (forkTestSet instanceof Class ? TestsToRun.fromClass((Class)((Class)forkTestSet)) : this.providerParameters.getScanResult().applyFilter(null, this.providerParameters.getTestClassLoader()));
            }
            if (this.providerParameters.getProviderProperties().get("threadCount") != null) {
                threadCount = Integer.parseInt((String)this.providerParameters.getProviderProperties().get("threadCount"));
            } else if (this.providerParameters.getProviderProperties().get("threadcount") != null) {
                threadCount = Integer.parseInt((String)this.providerParameters.getProviderProperties().get("threadcount"));
            }
            if (this.providerParameters.getProviderProperties().get("testFailureIgnore") != null) {
                stopOnError = !Boolean.parseBoolean((String)this.providerParameters.getProviderProperties().get("testFailureIgnore"));
                stopOnFailure = !Boolean.parseBoolean((String)this.providerParameters.getProviderProperties().get("testFailureIgnore"));
            }
            StringBuilder testNameBuilder = new StringBuilder("[");
            for (Class testClass : this.testsToRun) {
                if (testIndex++ > 0) {
                    testNameBuilder.append(',');
                }
                testNameBuilder.append(testClass.getSimpleName());
            }
            testNameBuilder.append(']');
            SurefireSleuthEventListener sleuthEventListener = new SurefireSleuthEventListener((RunListener)reportListener, RunMode.NORMAL_RUN);
            this.sleuthRunner.addListener((SleuthEventListener)sleuthEventListener);
            long startMilliseconds = System.currentTimeMillis();
            System.out.println(AnsiColor.YELLOW.getCode() + "Sleuth test set starting with thread count(" + threadCount + ") on groups " + (groups == null || groups.length == 0 ? "all" : Arrays.toString(groups)) + " in " + String.valueOf(testNameBuilder) + "..." + AnsiColor.DEFAULT.getCode());
            reportListener.testSetStarting((TestSetReportEntry)new SimpleReportEntry(RunMode.NORMAL_RUN, Long.valueOf(0L), testNameBuilder.toString(), "Sleuth Tests", "Test Assay", "Name Text", "super message 0"));
            this.sleuthRunner.execute((String[])(groups != null && groups.length == 0 ? null : groups), threadCount <= 0 ? Integer.MAX_VALUE : threadCount, stopOnError, stopOnFailure, (Iterable)this.testsToRun);
            System.out.println(AnsiColor.YELLOW.getCode() + "Sleuth test set completed in " + (System.currentTimeMillis() - startMilliseconds) + "ms" + AnsiColor.DEFAULT.getCode());
            reportListener.testSetCompleted((TestSetReportEntry)new SimpleReportEntry(RunMode.NORMAL_RUN, Long.valueOf(0L), testNameBuilder.toString(), "Sleuth Tests", "Test Assay", "nameText", Integer.valueOf((int)(System.currentTimeMillis() - startMilliseconds))));
            if (sleuthEventListener.getThrowable() != null) {
                throw new TestSetFailedException(sleuthEventListener.getThrowable());
            }
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    private String[] parseGroups(String groupsParameter) {
        if (groupsParameter != null && !groupsParameter.isEmpty()) {
            String[] parameterElements = groupsParameter.split(",", -1);
            int index = 0;
            String[] groups = new String[parameterElements.length];
            for (String parameterElement : parameterElements) {
                if ("all".equals(parameterElement)) {
                    return new String[0];
                }
                groups[index++] = parameterElement;
            }
            return groups;
        }
        return null;
    }
}

