/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.sleuth.maven.surefire;

import org.apache.maven.surefire.api.report.SafeThrowable;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.smallmind.nutsnbolts.lang.StackTraceUtility;
import org.smallmind.sleuth.runner.Culprit;

public class SleuthStackTraceWriter
implements StackTraceWriter {
    private final Throwable throwable;
    private final String testClass;
    private final String testMethod;

    public SleuthStackTraceWriter(String testClass, String testMethod, Throwable throwable) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.throwable = throwable;
    }

    public SafeThrowable getThrowable() {
        return this.throwable == null ? null : new SafeThrowable(this.throwable);
    }

    public String writeTraceToString() {
        return this.throwable == null ? "" : StackTraceUtility.obtainStackTraceAsString((Throwable)this.throwable);
    }

    public String writeTrimmedTraceToString() {
        return this.writeTraceToString();
    }

    public String smartTrimmedStackTrace() {
        if (this.throwable == null) {
            return "";
        }
        return new Culprit(this.testClass, this.testMethod, this.throwable).toString();
    }
}

