/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.sleuth.maven.surefire;

import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SimpleReportEntry;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.util.AnsiColor;
import org.smallmind.sleuth.maven.surefire.SleuthStackTraceWriter;
import org.smallmind.sleuth.runner.TestIdentifier;
import org.smallmind.sleuth.runner.event.ErrorSleuthEvent;
import org.smallmind.sleuth.runner.event.FailureSleuthEvent;
import org.smallmind.sleuth.runner.event.FatalSleuthEvent;
import org.smallmind.sleuth.runner.event.MootSleuthEvent;
import org.smallmind.sleuth.runner.event.SkippedSleuthEvent;
import org.smallmind.sleuth.runner.event.SleuthEvent;
import org.smallmind.sleuth.runner.event.SleuthEventListener;
import org.smallmind.sleuth.runner.event.SuccessSleuthEvent;

public class SurefireSleuthEventListener
implements SleuthEventListener {
    private final RunListener runListener;
    private final RunMode runMode;
    private Throwable throwable;

    public SurefireSleuthEventListener(RunListener runListener, RunMode runMode) {
        this.runListener = runListener;
        this.runMode = runMode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void handle(SleuthEvent event) {
        System.out.println("[" + AnsiColor.YELLOW.getCode() + "SUREFIRE" + AnsiColor.DEFAULT.getCode() + "] " + String.valueOf(event));
        switch (event.getType()) {
            case SETUP: {
                this.runListener.testSetStarting((TestSetReportEntry)new SimpleReportEntry(this.runMode, Long.valueOf(TestIdentifier.getTestIdentifier()), event.getClassName(), "source text", event.getMethodName(), "nameText"));
                break;
            }
            case START: {
                this.runListener.testStarting((ReportEntry)new SimpleReportEntry(this.runMode, Long.valueOf(TestIdentifier.getTestIdentifier()), event.getClassName(), "source text", event.getMethodName(), "nameText"));
                break;
            }
            case SUCCESS: {
                this.runListener.testSucceeded((ReportEntry)new SimpleReportEntry(this.runMode, Long.valueOf(TestIdentifier.getTestIdentifier()), event.getClassName(), "source text", event.getMethodName(), "nameText", Integer.valueOf((int)((SuccessSleuthEvent)event).getElapsed())));
                break;
            }
            case FAILURE: {
                this.runListener.testFailed((ReportEntry)new SimpleReportEntry(this.runMode, Long.valueOf(TestIdentifier.getTestIdentifier()), event.getClassName(), "source text", event.getMethodName(), "nameText", (StackTraceWriter)new SleuthStackTraceWriter(event.getClassName(), event.getMethodName(), ((FailureSleuthEvent)event).getThrowable()), Integer.valueOf((int)((FailureSleuthEvent)event).getElapsed())));
                break;
            }
            case ERROR: {
                this.runListener.testError((ReportEntry)new SimpleReportEntry(this.runMode, Long.valueOf(TestIdentifier.getTestIdentifier()), event.getClassName(), "source text", event.getMethodName(), "nameText", (StackTraceWriter)new SleuthStackTraceWriter(event.getClassName(), event.getMethodName(), ((ErrorSleuthEvent)event).getThrowable()), Integer.valueOf((int)((ErrorSleuthEvent)event).getElapsed())));
                break;
            }
            case SKIPPED: {
                this.runListener.testSkipped((ReportEntry)new SimpleReportEntry(this.runMode, Long.valueOf(TestIdentifier.getTestIdentifier()), event.getClassName(), "source text", event.getMethodName(), ((SkippedSleuthEvent)event).getMessage()));
                break;
            }
            case CANCELLED: {
                this.runListener.testSetCompleted((TestSetReportEntry)new SimpleReportEntry(this.runMode, Long.valueOf(TestIdentifier.getTestIdentifier()), event.getClassName(), "source text", event.getMethodName(), "Tests have been cancelled"));
                break;
            }
            case MOOT: {
                this.runListener.testAssumptionFailure((ReportEntry)new SimpleReportEntry(this.runMode, Long.valueOf(TestIdentifier.getTestIdentifier()), event.getClassName(), "source text", event.getMethodName(), "nameText", (StackTraceWriter)new SleuthStackTraceWriter(event.getClassName(), event.getMethodName(), ((MootSleuthEvent)event).getThrowable()), Integer.valueOf((int)((MootSleuthEvent)event).getElapsed())));
                break;
            }
            case FATAL: {
                this.throwable = ((FatalSleuthEvent)event).getThrowable();
                this.runListener.testExecutionSkippedByUser();
                break;
            }
            default: {
                throw new UnknownSwitchCaseException(event.getType().name(), new Object[0]);
            }
        }
    }
}

