/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.jackson;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json", "text/json"})
@Produces(value={"application/json", "text/json"})
public class JsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final ThreadLocal<ByteArrayOutputStream> WRITE_BUFFER_LOCAL = new ThreadLocal();
    private static final ObjectMapper objectMapper = new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return objectMapper.readValue(entityStream, type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        WRITE_BUFFER_LOCAL.set(new ByteArrayOutputStream());
        try {
            objectMapper.writeValue((OutputStream)WRITE_BUFFER_LOCAL.get(), o);
            return WRITE_BUFFER_LOCAL.get().size();
        }
        catch (Throwable throwable) {
            throw new WebApplicationException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            if (WRITE_BUFFER_LOCAL.get() == null) {
                this.getSize(o, type, genericType, annotations, mediaType);
            }
            entityStream.write(WRITE_BUFFER_LOCAL.get().toByteArray());
        }
        finally {
            WRITE_BUFFER_LOCAL.remove();
        }
    }
}

