/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.aop;

import java.util.Arrays;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;

public class ValidationException
extends RuntimeException {
    public <T> ValidationException(Set<ConstraintViolation<T>> constraintViolationSet) {
        super(ValidationException.convert(constraintViolationSet));
    }

    private static <T> String convert(Set<ConstraintViolation<T>> constraintViolationSet) {
        Object[] violations = new Violation[constraintViolationSet.size()];
        int index = 0;
        for (ConstraintViolation<T> constraintViolation : constraintViolationSet) {
            violations[index++] = new Violation(constraintViolation);
        }
        return Arrays.toString(violations);
    }

    private static class Violation {
        private Path propertyPath;
        private String message;

        public Violation(ConstraintViolation<?> constraintViolation) {
            this.propertyPath = constraintViolation.getPropertyPath();
            this.message = constraintViolation.getMessage();
        }

        public String toString() {
            return "[propertyPath = " + this.propertyPath + ", message = " + this.message + ']';
        }
    }
}

