/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.fault;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="element")
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class FaultElement {
    private String declaringType;
    private String functionName;
    private String fileName;
    private int lineNumber;

    public FaultElement() {
    }

    public FaultElement(String declaringType, String functionName) {
        this.declaringType = declaringType;
        this.functionName = functionName;
        this.lineNumber = -1;
    }

    public FaultElement(String declaringType, String functionName, String fileName, int lineNumber) {
        this.declaringType = declaringType;
        this.functionName = functionName;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public FaultElement(StackTraceElement stackTraceElement) {
        this.declaringType = stackTraceElement.getClassName();
        this.functionName = stackTraceElement.getMethodName();
        this.fileName = stackTraceElement.getFileName();
        this.lineNumber = stackTraceElement.getLineNumber();
    }

    @XmlElement(name="type", required=true, nillable=false)
    public String getDeclaringType() {
        return this.declaringType;
    }

    public void setDeclaringType(String declaringType) {
        this.declaringType = declaringType;
    }

    @XmlElement(name="function", required=true, nillable=false)
    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @XmlElement(name="file", required=true, nillable=false)
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @XmlElement(name="line", required=true, nillable=false)
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String toString() {
        StringBuilder prettyBuilder = new StringBuilder(this.declaringType);
        prettyBuilder.append('.').append(this.functionName);
        if (this.fileName != null && this.lineNumber >= 0) {
            prettyBuilder.append('(').append(this.fileName).append(':').append(this.lineNumber).append(')');
        } else if (this.fileName != null) {
            prettyBuilder.append('(').append(this.fileName).append(')');
        } else {
            prettyBuilder.append("(Unknown Source)");
        }
        return prettyBuilder.toString();
    }

    public int hashCode() {
        int result = 31 * this.declaringType.hashCode() + this.functionName.hashCode();
        result = 31 * result + Objects.hashCode(this.fileName);
        result = 31 * result + this.lineNumber;
        return result;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof FaultElement && ((FaultElement)obj).getDeclaringType().equals(this.declaringType) && ((FaultElement)obj).getFunctionName().equals(this.functionName) && ((FaultElement)obj).getFileName().equals(this.fileName) && ((FaultElement)obj).getLineNumber() == this.lineNumber;
    }
}

