/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.fault;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.smallmind.nutsnbolts.reflection.type.GenericUtility;
import org.smallmind.web.jersey.fault.ConcreteExceptionMapper;
import org.smallmind.web.jersey.fault.Fault;
import org.smallmind.web.jersey.fault.FaultWrappingException;

@Provider
public class ThrowableExceptionMapper
implements ExceptionMapper<Throwable> {
    private ConcreteExceptionMapper[] mappers;

    public ThrowableExceptionMapper(ConcreteExceptionMapper ... mappers) {
        this.mappers = mappers;
    }

    public Response toResponse(Throwable throwable) {
        if (this.mappers != null) {
            ConcreteExceptionMapper[] concreteExceptionMapperArray = this.mappers;
            int n = this.mappers.length;
            int n2 = 0;
            while (n2 < n) {
                Response response;
                ConcreteExceptionMapper mapper = concreteExceptionMapperArray[n2];
                Class mappedThrowableClass = (Class)GenericUtility.getTypeArguments(ConcreteExceptionMapper.class, mapper.getClass()).get(0);
                if (mappedThrowableClass.isAssignableFrom(throwable.getClass()) && (response = mapper.toResponse(throwable)) != null) {
                    return response;
                }
                ++n2;
            }
        }
        if (throwable instanceof WebApplicationException) {
            return ((WebApplicationException)throwable).getResponse();
        }
        return Response.status((int)500).type("application/json").entity((Object)(throwable instanceof FaultWrappingException ? ((FaultWrappingException)throwable).getFault() : new Fault(throwable))).build();
    }
}

