/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.aop;

import java.lang.reflect.Constructor;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.web.jersey.aop.JsonEntity;
import org.smallmind.web.jersey.aop.ParameterAnnotations;
import org.smallmind.web.jersey.aop.ParameterProcessingException;
import org.smallmind.web.jersey.util.JsonCodec;

public abstract class AbstractIndexedJsonEntity
implements JsonEntity {
    private static final Class[] NO_ARG_SIGNATURE = new Class[0];
    private Object[] arguments;

    public AbstractIndexedJsonEntity() {
    }

    public AbstractIndexedJsonEntity(Object[] arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    @Override
    public <T> T getParameter(String key, Class<T> clazz, ParameterAnnotations parameterAnnotations) {
        int index;
        try {
            index = Integer.parseInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterProcessingException(numberFormatException);
        }
        if (index < 0) {
            throw new ParameterProcessingException("Entity argument index must be >= 0", new Object[0]);
        }
        if (index >= this.arguments.length) {
            return null;
        }
        XmlJavaTypeAdapter xmlJavaTypeAdapter = parameterAnnotations.getAnnotation(XmlJavaTypeAdapter.class);
        if (xmlJavaTypeAdapter != null) {
            try {
                Constructor adapterConstructor = xmlJavaTypeAdapter.value().getConstructor(NO_ARG_SIGNATURE);
                if (adapterConstructor == null) {
                    throw new ParameterProcessingException("XmlAdapter of type(%s) must have a no arg constructor", xmlJavaTypeAdapter.value().getName());
                }
                XmlAdapter xmlAdapter = (XmlAdapter)adapterConstructor.newInstance(new Object[0]);
                return JsonCodec.convert(xmlAdapter.unmarshal(this.arguments[index]), clazz);
            }
            catch (Exception exception) {
                throw new ParameterProcessingException(exception);
            }
        }
        return JsonCodec.convert(this.arguments[index], clazz);
    }
}

