/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.util;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import java.lang.reflect.InvocationHandler;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.nutsnbolts.reflection.AnnotationFilter;
import org.smallmind.nutsnbolts.reflection.OffloadingInvocationHandler;
import org.smallmind.nutsnbolts.reflection.PassType;
import org.smallmind.nutsnbolts.reflection.ProxyGenerator;
import org.smallmind.web.jersey.util.JAXBProcessingException;

public class PolymorphicValueInstantiator
extends StdValueInstantiator {
    private static final ThreadLocal<Object> polymorphicInstanceThreadLocal = new ThreadLocal();
    private Class<?> polymorphicSubClass;

    public PolymorphicValueInstantiator(StdValueInstantiator src, Class<?> polymorphicSubClass) {
        super(src);
        this.polymorphicSubClass = polymorphicSubClass;
    }

    public static void setPolymorphicInstance(Object obj) {
        polymorphicInstanceThreadLocal.set(obj);
    }

    public boolean canCreateUsingDefault() {
        return true;
    }

    public Object createUsingDefault(DeserializationContext ctxt) {
        Object polymorphicInstance = polymorphicInstanceThreadLocal.get();
        if (polymorphicInstance == null) {
            throw new JAXBProcessingException("Can not update a 'null' instance of the polymorphic sub-class(%s)", this.polymorphicSubClass.getName());
        }
        try {
            Object object = ProxyGenerator.createProxy(this.polymorphicSubClass, (InvocationHandler)new OffloadingInvocationHandler(polymorphicInstance), (AnnotationFilter)new AnnotationFilter(PassType.EXCLUDE, new Class[]{XmlJavaTypeAdapter.class}));
            return object;
        }
        finally {
            polymorphicInstanceThreadLocal.remove();
        }
    }
}

