/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Path;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.http.HttpEntity;
import org.smallmind.scribe.pen.Level;
import org.smallmind.web.jersey.aop.EntityParam;
import org.smallmind.web.jersey.proxy.Argument;
import org.smallmind.web.jersey.proxy.Envelope;
import org.smallmind.web.jersey.proxy.JsonArgument;
import org.smallmind.web.jersey.proxy.JsonHeader;
import org.smallmind.web.jersey.proxy.JsonHeaderInjector;
import org.smallmind.web.jersey.proxy.JsonHttpEntity;
import org.smallmind.web.jersey.proxy.JsonTarget;
import org.smallmind.web.jersey.proxy.ResourceDefinitionException;

public class JsonEntityInvocationHandler
implements InvocationHandler {
    private final ConcurrentHashMap<Class<?>, XmlAdapter> xmlAdapterMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Method, JsonArgument[]> jsonArgumentMap = new ConcurrentHashMap();
    private final Level level;
    private final JsonTarget target;
    private final JsonHeaderInjector[] headerInjectors;
    private final String serviceName;
    private final String basePath;
    private final int serviceVersion;

    public JsonEntityInvocationHandler(JsonTarget target, String versionPrefix, int serviceVersion, String serviceName, Level level, JsonHeaderInjector ... headerInjectors) {
        this.target = target;
        this.serviceVersion = serviceVersion;
        this.serviceName = serviceName;
        this.level = level;
        this.headerInjectors = headerInjectors;
        this.basePath = "/" + versionPrefix + serviceVersion + '/' + serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Path pathAnnotation = method.getAnnotation(Path.class);
        JsonArgument[] jsonArguments = this.jsonArgumentMap.get(method);
        if (jsonArguments == null) {
            ConcurrentHashMap<Method, JsonArgument[]> concurrentHashMap = this.jsonArgumentMap;
            synchronized (concurrentHashMap) {
                jsonArguments = this.jsonArgumentMap.get(method);
                if (jsonArguments == null) {
                    jsonArguments = this.constructJsonArguments(method);
                    this.jsonArgumentMap.put(method, jsonArguments);
                }
            }
        }
        Argument[] arguments = new Argument[args.length];
        int index = 0;
        while (index < args.length) {
            arguments[index] = new Argument(jsonArguments[index].getName(), jsonArguments[index].getXmlAdapter() != null ? jsonArguments[index].getXmlAdapter().marshal(args[index]) : args[index]);
            ++index;
        }
        JsonTarget rectifiedTarget = this.target.path(String.valueOf(this.basePath) + (pathAnnotation != null ? pathAnnotation.value() : String.valueOf('/') + method.getName()));
        if (this.headerInjectors != null) {
            JsonHeaderInjector[] jsonHeaderInjectorArray = this.headerInjectors;
            int n = this.headerInjectors.length;
            int n2 = 0;
            while (n2 < n) {
                JsonHeaderInjector headerInjector = jsonHeaderInjectorArray[n2];
                JsonHeader header = headerInjector.injectOnInvoke(proxy, method, args);
                if (header != null) {
                    rectifiedTarget.header(header.getKey(), header.getValue());
                }
                ++n2;
            }
        }
        return rectifiedTarget.debug(this.level).post((HttpEntity)new JsonHttpEntity(new Envelope(arguments)), method.getReturnType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonArgument[] constructJsonArguments(Method method) throws ResourceDefinitionException, IllegalAccessException, InstantiationException {
        JsonArgument[] jsonArguments = new JsonArgument[method.getParameterTypes().length];
        int index = 0;
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation[] parameterAnnotations = annotationArray[n2];
            String name = null;
            XmlAdapter xmlAdapter = null;
            Annotation[] annotationArray2 = parameterAnnotations;
            int n3 = parameterAnnotations.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray2[n4];
                if (annotation.annotationType().equals(EntityParam.class)) {
                    name = ((EntityParam)annotation).value();
                }
                if (annotation.annotationType().equals(XmlJavaTypeAdapter.class) && (xmlAdapter = this.xmlAdapterMap.get(((XmlJavaTypeAdapter)annotation).value())) == null) {
                    ConcurrentHashMap<Class<?>, XmlAdapter> concurrentHashMap = this.xmlAdapterMap;
                    synchronized (concurrentHashMap) {
                        xmlAdapter = this.xmlAdapterMap.get(((XmlJavaTypeAdapter)annotation).value());
                        if (xmlAdapter == null) {
                            xmlAdapter = (XmlAdapter)((XmlJavaTypeAdapter)annotation).value().newInstance();
                            this.xmlAdapterMap.put(((XmlJavaTypeAdapter)annotation).value(), xmlAdapter);
                        }
                    }
                }
                ++n4;
            }
            if (name == null) {
                throw new ResourceDefinitionException("The method(%s) of resource interface(%s) version(%d) requires @EntityParameter annotations", method.getName(), this.serviceName, this.serviceVersion);
            }
            jsonArguments[index++] = new JsonArgument(name, xmlAdapter);
            ++n2;
        }
        return jsonArguments;
    }
}

