/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.lang.reflect.InvocationHandler;
import java.util.LinkedHashMap;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.nutsnbolts.reflection.AnnotationFilter;
import org.smallmind.nutsnbolts.reflection.OffloadingInvocationHandler;
import org.smallmind.nutsnbolts.reflection.PassType;
import org.smallmind.nutsnbolts.reflection.ProxyGenerator;
import org.smallmind.nutsnbolts.reflection.type.GenericUtility;
import org.smallmind.web.jersey.util.JAXBProcessingException;
import org.smallmind.web.jersey.util.JsonCodec;
import org.smallmind.web.jersey.util.PolymorphicClassCache;
import org.smallmind.web.jersey.util.PolymorphicValueInstantiator;
import org.smallmind.web.jersey.util.XmlPolymorphicSubClasses;

public abstract class PolymorphicXmlAdapter<T>
extends XmlAdapter<LinkedHashMap<String, Object>, T> {
    private Class<?> baseClass = (Class)GenericUtility.getTypeArguments(PolymorphicXmlAdapter.class, ((Object)((Object)this)).getClass()).get(0);

    public T unmarshal(LinkedHashMap<String, Object> map) {
        Object polymorphicInstance;
        if (map.size() != 1) {
            throw new JAXBProcessingException("The json for the sub-class of class(%s) is improperly formatted", this.baseClass.getName());
        }
        String polymorphicKey = map.keySet().iterator().next();
        Class<?> polymorphicSubClass = PolymorphicClassCache.getPolymorphicSubClass(this.baseClass, polymorphicKey);
        if (polymorphicSubClass == null) {
            throw new JAXBProcessingException("Unable to map the root element name(%s) to any known sub-class of class(%s) listed in the %s annotation", polymorphicKey, this.baseClass.getName(), XmlPolymorphicSubClasses.class.getSimpleName());
        }
        Class<?> proxySubClass = PolymorphicClassCache.getProxyClassForPolymorphicClass(polymorphicSubClass);
        if (proxySubClass == null) {
            Object proxyObject = ProxyGenerator.createProxy(polymorphicSubClass, null, (AnnotationFilter)new AnnotationFilter(PassType.EXCLUDE, new Class[]{XmlJavaTypeAdapter.class}));
            proxySubClass = proxyObject.getClass();
            PolymorphicClassCache.addClassRelationship(polymorphicSubClass, proxySubClass);
        }
        try {
            polymorphicInstance = polymorphicSubClass.newInstance();
            PolymorphicValueInstantiator.setPolymorphicInstance(polymorphicInstance);
        }
        catch (Exception exception) {
            throw new JAXBProcessingException(exception);
        }
        JsonCodec.convert(map.get(polymorphicKey), proxySubClass);
        return (T)polymorphicInstance;
    }

    public LinkedHashMap<String, Object> marshal(T value) throws JsonProcessingException {
        if (value.getClass().equals(this.baseClass)) {
            throw new JAXBProcessingException("Attempting to serialize the polymorphic root class(%s) would be infinitely recursive", this.baseClass.getName());
        }
        XmlRootElement xmlRootElementAnnotation = value.getClass().getAnnotation(XmlRootElement.class);
        if (xmlRootElementAnnotation == null) {
            throw new JAXBProcessingException("The class(%s) is missing a %s annotation", value.getClass().getName(), XmlRootElement.class.getSimpleName());
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Object proxyObject = ProxyGenerator.createProxy(value.getClass(), (InvocationHandler)new OffloadingInvocationHandler(value), (AnnotationFilter)new AnnotationFilter(PassType.EXCLUDE, new Class[]{XmlJavaTypeAdapter.class}));
        PolymorphicClassCache.addClassRelationship(value.getClass(), proxyObject.getClass());
        linkedHashMap.put(xmlRootElementAnnotation.name(), proxyObject);
        return linkedHashMap;
    }
}

